package com.zurrtum.create.foundation.gui.menu;

import com.zurrtum.create.foundation.utility.IInteractionChecker;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;

public abstract class MenuBase<T> extends class_1703 {
    public class_1657 player;
    public class_1661 playerInventory;
    public T contentHolder;
    private final MenuType<T> type;

    protected MenuBase(MenuType<T> type, int id, class_1661 inv, T contentHolder) {
        super(null, id);
        this.type = type;
        init(inv, contentHolder);
    }

    public MenuType<T> getMenuType() {
        return type;
    }

    protected void init(class_1661 inv, T contentHolderIn) {
        player = inv.field_7546;
        playerInventory = inv;
        contentHolder = contentHolderIn;
        initAndReadInventory(contentHolder);
        addSlots();
        method_7623();
    }

    protected abstract void initAndReadInventory(T contentHolder);

    protected abstract void addSlots();

    protected abstract void saveData(T contentHolder);

    protected void addPlayerSlots(int x, int y) {
        for (int row = 0; row < 3; ++row)
            for (int col = 0; col < 9; ++col)
                this.method_7621(this.createPlayerSlot(playerInventory, col + row * 9 + 9, x + col * 18, y + row * 18));
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot)
            this.method_7621(this.createPlayerSlot(playerInventory, hotbarSlot, x + hotbarSlot * 18, y + 58));
    }

    protected class_1735 createPlayerSlot(class_1661 inventory, int index, int x, int y) {
        return new class_1735(inventory, index, x, y);
    }

    @Override
    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        saveData(contentHolder);
    }

    @Override
    public boolean method_7597(class_1657 player) {
        if (contentHolder == null)
            return false;
        if (contentHolder instanceof IInteractionChecker)
            return ((IInteractionChecker) contentHolder).canPlayerUse(player);
        return true;
    }

}
