package com.zurrtum.create.foundation.pack;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.kinetics.fan.processing.SplashingRecipe;
import com.zurrtum.create.content.kinetics.saw.CuttingRecipe;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import com.zurrtum.create.foundation.data.recipe.Mods;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2248;
import net.minecraft.class_2292;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_6862;
import net.minecraft.class_7475;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

import static com.zurrtum.create.Create.MOD_ID;

public class RuntimeDataGenerator {
    private static final Set<String> IGNORES = Set.of(class_2960.field_33381, MOD_ID);
    // (1. variant_prefix, optional, can be null)stripped_(2. wood name)(3. type)(4. empty group)endofline
    private static final Pattern STRIPPED_WOODS_PREFIX_REGEX = Pattern.compile(
        "(\\w*)??stripped_(\\w*)(_log|_wood|_stem|_hyphae|_block|(?<!_)wood)()$");
    // (1. wood name)(2. type)(3. variant_suffix, optional)_stripped(4. 2nd variant_suffix, optional)
    private static final Pattern STRIPPED_WOOD_SUFFIX_REGEX = Pattern.compile(
        "(\\w*)(_log|_wood|_stem|_hyphae|_block|(?<!_)wood)(\\w*)_stripped(\\w*)");
    // startofline(not preceded by stripped_)(1. wood_name)(2. type)(3. (4. variant suffix), optional, that doesn't end in _stripped, can be null)endofline
    private static final Pattern NON_STRIPPED_WOODS_REGEX = Pattern.compile(
        "^(?!stripped_)([a-z_]+)(_log|_wood|_stem|_hyphae|(?<!bioshroom)_block)(([a-z_]+)(?<!_stripped))?$");
    private static final Multimap<class_2960, class_3497> TAGS = HashMultimap.create();
    private static final Object2ObjectOpenHashMap<class_2960, JsonElement> JSON_FILES = new Object2ObjectOpenHashMap<>();
    private static final Map<class_2960, class_2960> MISMATCHED_WOOD_NAMES = ImmutableMap.<class_2960, class_2960>builder()
        .put(Mods.ARS_N.asResource("blue_archwood"), Mods.ARS_N.asResource("archwood")) // Generate recipes for planks -> everything else
        //.put(Mods.UUE.asResource("chorus_cane"), Mods.UUE.asResource("chorus_nest")) // Has a weird setup with both normal and stripped planks, that it already provides cutting recipes for
        .put(Mods.DD.asResource("blooming"), Mods.DD.asResource("bloom")).build();

    public static void insertIntoPack(DynamicPack dynamicPack) {
        class_2960 cuttingId = class_7923.field_41188.method_10221(AllRecipeTypes.CUTTING);
        class_2960 splashingId = class_7923.field_41188.method_10221(AllRecipeTypes.SPLASHING);
        for (class_2960 itemId : class_7923.field_41178.method_10235()) {
            if (IGNORES.contains(itemId.method_12836())) {
                continue;
            }
            cuttingRecipes(cuttingId, itemId);
            washingRecipes(splashingId, itemId);
        }

        if (!JSON_FILES.isEmpty()) {
            Create.LOGGER.info("Created {} recipes which will be injected into the game", JSON_FILES.size());
            JSON_FILES.forEach(dynamicPack::put);
            JSON_FILES.clear();
            JSON_FILES.trim();
        }

        if (!TAGS.isEmpty()) {
            Create.LOGGER.info("Created {} tags which will be injected into the game", TAGS.size());
            for (Map.Entry<class_2960, Collection<class_3497>> tags : TAGS.asMap().entrySet()) {
                class_7475 tagFile = new class_7475(new ArrayList<>(tags.getValue()), false);
                dynamicPack.put(
                    tags.getKey().method_45138("tags/item/"),
                    class_7475.field_39269.encodeStart(JsonOps.INSTANCE, tagFile).result().orElseThrow()
                );
            }
            TAGS.clear();
        }
    }

    // logs/woods -> stripped variants
    // logs/woods both stripped and non stripped -> planks
    // planks -> stairs, slabs, fences, fence gates, doors, trapdoors, pressure plates, buttons and signs
    private static void cuttingRecipes(class_2960 typeId, class_2960 itemId) {
        String path = itemId.method_12832();

        Matcher match = STRIPPED_WOODS_PREFIX_REGEX.matcher(path);
        boolean hasFoundMatch = match.find();
        boolean strippedInPrefix = hasFoundMatch;

        if (!hasFoundMatch) {
            match = STRIPPED_WOOD_SUFFIX_REGEX.matcher(path);
            hasFoundMatch = match.find();
        }

        // Last ditch attempt. Try to find logs without stripped variants
        boolean noStrippedVariant = false;
        if (!hasFoundMatch && !class_7923.field_41178.method_10250(itemId.method_45138("stripped_")) && !class_7923.field_41178.method_10250(itemId.method_48331(
            "_stripped"))) {
            match = NON_STRIPPED_WOODS_REGEX.matcher(path);
            hasFoundMatch = match.find();
            noStrippedVariant = true;
        }

        if (hasFoundMatch) {
            String prefix = strippedInPrefix && match.group(1) != null ? match.group(1) : "";
            String suffix = !strippedInPrefix && !noStrippedVariant ? match.group(3) + match.group(4) : "";
            String type = match.group(strippedInPrefix ? 3 : 2);
            class_2960 matched_name = itemId.method_45136(match.group(strippedInPrefix ? 2 : 1));
            // re-add 'wood' to wood types such as Botania's livingwood
            class_2960 base = matched_name.method_48331(type.equals("wood") ? "wood" : "");
            base = MISMATCHED_WOOD_NAMES.getOrDefault(base, base);
            class_2960 nonStrippedId = matched_name.method_48331(type).method_45138(prefix).method_48331(suffix);
            class_2960 planksId = base.method_48331("_planks");
            class_2960 stairsId = base.method_48331(base.method_12836().equals(Mods.BTN.getId()) ? "_planks_stairs" : "_stairs");
            class_2960 slabId = base.method_48331(base.method_12836().equals(Mods.BTN.getId()) ? "_planks_slab" : "_slab");
            class_2960 fenceId = base.method_48331("_fence");
            class_2960 fenceGateId = base.method_48331("_fence_gate");
            class_2960 doorId = base.method_48331("_door");
            class_2960 trapdoorId = base.method_48331("_trapdoor");
            class_2960 pressurePlateId = base.method_48331("_pressure_plate");
            class_2960 buttonId = base.method_48331("_button");
            class_2960 signId = base.method_48331("_sign");
            // Bamboo, GotD whistlecane
            int planksCount = type.contains("block") ? 3 : 6;

            if (!noStrippedVariant) {
                // Catch mods like JNE that have a non-stripped log prefixed but not the stripped log
                if (class_7923.field_41178.method_10250(nonStrippedId)) {
                    simpleWoodRecipe(typeId, nonStrippedId, itemId);
                }
                simpleWoodRecipe(typeId, itemId, planksId, planksCount);
            } else if (class_7923.field_41178.method_10250(planksId)) {
                class_2960 tag = class_2960.method_60655(MOD_ID, "runtime_generated/compat/" + itemId.method_12836() + "/" + base.method_12832());
                insertIntoTag(tag, itemId);

                simpleWoodRecipe(typeId, class_6862.method_40092(class_7924.field_41197, tag), planksId, planksCount);
            }

            if (!path.contains("_wood") && !path.contains("_hyphae") && class_7923.field_41178.method_10250(planksId)) {
                simpleWoodRecipe(typeId, planksId, stairsId);
                simpleWoodRecipe(typeId, planksId, slabId, 2);
                simpleWoodRecipe(typeId, planksId, fenceId);
                simpleWoodRecipe(typeId, planksId, fenceGateId);
                simpleWoodRecipe(typeId, planksId, doorId);
                simpleWoodRecipe(typeId, planksId, trapdoorId);
                simpleWoodRecipe(typeId, planksId, pressurePlateId);
                simpleWoodRecipe(typeId, planksId, buttonId);
                simpleWoodRecipe(typeId, planksId, signId);
            }
        }
    }

    private static void washingRecipes(class_2960 typeId, class_2960 itemId) {
        class_2248 block = class_7923.field_41175.method_63535(itemId);
        if (block instanceof class_2292 concretePowderBlock) {
            simpleSplashingRecipe(typeId, itemId, class_7923.field_41175.method_10221(concretePowderBlock.field_10810));
        }
    }

    private static void insertIntoTag(class_2960 tag, class_2960 itemId) {
        if (class_7923.field_41178.method_10250(itemId))
            TAGS.put(tag, class_3497.method_43942(itemId));
    }

    private static void simpleWoodRecipe(class_2960 typeId, class_2960 inputId, class_2960 outputId) {
        simpleWoodRecipe(typeId, inputId, outputId, 1);
    }

    private static void simpleWoodRecipe(class_2960 typeId, class_2960 inputId, class_2960 outputId, int amount) {
        if (class_7923.field_41178.method_10250(outputId)) {
            addRecipe(
                typeId,
                inputId.method_12836(),
                inputId.method_12832(),
                outputId.method_12832(),
                new CuttingRecipe(50, new class_1799(class_7923.field_41178.method_63535(outputId), amount), class_1856.method_8101(class_7923.field_41178.method_63535(inputId)))
            );
        }
    }

    private static void simpleWoodRecipe(class_2960 typeId, class_6862<class_1792> inputTag, class_2960 outputId, int amount) {
        if (class_7923.field_41178.method_10250(outputId)) {
            class_1860.field_47319.encodeStart(
                EmptyJsonOps.INSTANCE,
                new CuttingRecipe(50, new class_1799(class_7923.field_41178.method_63535(outputId), amount), EmptyJsonOps.ofTag(inputTag))
            ).ifSuccess(json -> {
                class_2960 inputId = inputTag.comp_327();
                class_2960 path = class_2960.method_60655(
                    typeId.method_12836(),
                    "recipe/" + typeId.method_12832() + "/runtime_generated/compat/" + inputId.method_12836() + "/" + "tag_" + inputId.method_12832() + "_to_" + outputId.method_12832()
                );
                JSON_FILES.put(path, json);
            });
        }
    }

    private static void simpleSplashingRecipe(class_2960 typeId, class_2960 first, class_2960 second) {
        addRecipe(
            typeId,
            first.method_12836(),
            first.method_12832(),
            second.method_12832(),
            new SplashingRecipe(
                List.of(new ChanceOutput(1, new class_1799(class_7923.field_41175.method_63535(second)))),
                class_1856.method_8101(class_7923.field_41175.method_63535(first))
            )
        );
    }

    private static void addRecipe(class_2960 typeId, String modid, String from, String to, class_1860<?> recipe) {
        class_1860.field_47319.encodeStart(JsonOps.INSTANCE, recipe).ifSuccess(json -> {
            class_2960 path = class_2960.method_60655(
                typeId.method_12836(),
                "recipe/" + typeId.method_12832() + "/runtime_generated/compat/" + modid + "/" + from + "_to_" + to
            );
            JSON_FILES.put(path, json);
        });
    }
}