package com.zurrtum.create.foundation.recipe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_10302;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import net.minecraft.class_9331;

public class ComponentsIngredient extends class_1856 {
    public static final String TYPE_KEY = "fabric:type";
    public static final class_2960 ID = class_2960.method_60655("fabric", "components");
    public static final String STRING_ID = ID.toString();
    public static final Codec<ComponentsIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        class_2960.field_25139.optionalFieldOf(TYPE_KEY).forGetter(i -> Optional.of(ID)),
        class_1856.field_46095.fieldOf("base").forGetter(ComponentsIngredient::getBase),
        class_9326.field_49589.fieldOf("components").forGetter(ComponentsIngredient::getComponents)
    ).apply(instance, (id, base, components) -> new ComponentsIngredient(base, components)));
    public static final class_9139<class_9129, ComponentsIngredient> field_48355 = class_9139.method_56435(
        class_1856.field_48355,
        ComponentsIngredient::getBase,
        class_9326.field_49590,
        ComponentsIngredient::getComponents,
        ComponentsIngredient::new
    );
    private final class_1856 base;
    private final class_9326 components;

    @SuppressWarnings("deprecation")
    public ComponentsIngredient(class_1856 base, class_9326 components) {
        // We must pass a registry entry list that contains something that isn't air. It doesn't actually get used.
        super(class_6885.method_40246(class_1802.field_20391.method_40131()));

        if (components.method_57848()) {
            throw new IllegalArgumentException("ComponentIngredient must have at least one defined component");
        }

        this.base = base;
        this.components = components;
    }

    @Override
    @SuppressWarnings("deprecation")
    public Stream<class_6880<class_1792>> method_8105() {
        return base.method_8105();
    }

    @Override
    public boolean method_65799() {
        return base.method_65799();
    }

    @Override
    public boolean method_8093(class_1799 stack) {
        if (!base.method_8093(stack))
            return false;

        // None strict matching
        for (Map.Entry<class_9331<?>, Optional<?>> entry : components.method_57846()) {
            final class_9331<?> type = entry.getKey();
            final Optional<?> value = entry.getValue();

            if (value.isPresent()) {
                // Expect the stack to contain a matching component
                if (!stack.method_57826(type)) {
                    return false;
                }

                if (!Objects.equals(value.get(), stack.method_58694(type))) {
                    return false;
                }
            } else {
                // Expect the target stack to not contain this component
                if (stack.method_57826(type)) {
                    return false;
                }
            }
        }

        return true;
    }

    @Override
    public boolean method_65798(class_6880<class_1792> registryEntry) {
        return base.method_65798(registryEntry);
    }

    private class_1856 getBase() {
        return base;
    }

    @Nullable
    private class_9326 getComponents() {
        return components;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        ComponentsIngredient that = (ComponentsIngredient) o;
        return base.equals(that.base) && components.equals(that.components);
    }

    @Override
    public class_10302 method_64673() {
        return new class_10302.class_10304(base.method_8105().map(this::createEntryDisplay).toList());
    }

    private class_10302 createEntryDisplay(class_6880<class_1792> entry) {
        class_1799 stack = entry.comp_349().method_7854();
        stack.method_59692(components);
        return new class_10302.class_10307(stack);
    }
}
