package com.zurrtum.create.infrastructure.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;

public class ClipboardEntry {
    public static final Codec<ClipboardEntry> CODEC = RecordCodecBuilder.create(i -> i.group(
        Codec.BOOL.fieldOf("checked").forGetter(c -> c.checked),
        class_8824.field_46597.fieldOf("text").forGetter(c -> c.text),
        class_1799.field_49266.fieldOf("icon").forGetter(c -> c.icon),
        Codec.INT.fieldOf("item_amount").forGetter(c -> c.itemAmount)
    ).apply(
        i, (checked, text, icon, itemAmount) -> {
            ClipboardEntry entry = new ClipboardEntry(checked, text.method_27661());
            if (!icon.method_7960())
                entry.displayItem(icon, itemAmount);

            return entry;
        }
    ));

    public static final class_9139<class_9129, ClipboardEntry> STREAM_CODEC = class_9139.method_56905(
        class_9135.field_48547,
        c -> c.checked,
        class_8824.field_49668,
        c -> c.text,
        class_1799.field_49268,
        c -> c.icon,
        class_9135.field_49675,
        c -> c.itemAmount,
        (checked, text, icon, itemAmount) -> {
            ClipboardEntry entry = new ClipboardEntry(checked, text.method_27661());
            if (!icon.method_7960())
                entry.displayItem(icon, itemAmount);

            return entry;
        }
    );

    public boolean checked;
    public class_5250 text;
    public class_1799 icon;
    public int itemAmount;

    public ClipboardEntry(boolean checked, class_5250 text) {
        this.checked = checked;
        this.text = text;
        this.icon = class_1799.field_8037;
    }

    public ClipboardEntry displayItem(class_1799 icon, int amount) {
        this.icon = icon;
        this.itemAmount = amount;
        return this;
    }

    public static List<List<ClipboardEntry>> readAll(class_1799 clipboardItem) {
        return readAll(clipboardItem.method_57353());
    }

    public static List<List<ClipboardEntry>> readAll(class_9323 components) {
        return readAll(components.method_58694(AllDataComponents.CLIPBOARD_CONTENT));
    }

    public static List<List<ClipboardEntry>> readAll(@Nullable ClipboardContent content) {
        if (content == null)
            return new ArrayList<>();

        // Both these lists are immutable, so we unfortunately need to re-create them to make them mutable
        List<List<ClipboardEntry>> saved = content.pages();

        List<List<ClipboardEntry>> entries = new ArrayList<>(saved.size());
        for (List<ClipboardEntry> inner : saved)
            entries.add(new ArrayList<>(inner));

        return entries;
    }

    public static List<ClipboardEntry> getLastViewedEntries(class_1799 heldItem) {
        List<List<ClipboardEntry>> pages = ClipboardEntry.readAll(heldItem);
        if (pages.isEmpty()) {
            return new ArrayList<>();
        }
        int previouslyOpenedPage = heldItem.method_58695(AllDataComponents.CLIPBOARD_CONTENT, ClipboardContent.EMPTY).previouslyOpenedPage();
        int page = Math.min(previouslyOpenedPage, pages.size() - 1);
        return pages.get(page);
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof ClipboardEntry that))
            return false;

        return checked == that.checked && text.equals(that.text) && class_1799.method_31577(icon, that.icon);
    }

    @Override
    public int hashCode() {
        int result = Boolean.hashCode(checked);
        result = 31 * result + text.hashCode();
        result = 31 * result + class_1799.method_57355(icon);
        return result;
    }
}
