package com.zurrtum.create.infrastructure.component;

import com.mojang.serialization.Codec;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;

import java.util.Locale;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_9139;

public enum ClipboardType implements class_3542 {
    EMPTY("empty_clipboard"),
    WRITTEN("clipboard"),
    EDITING("clipboard_and_quill");

    public static final Codec<ClipboardType> CODEC = class_3542.method_28140(ClipboardType::values);
    public static final class_9139<ByteBuf, ClipboardType> STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(ClipboardType.class);

    public final String file;
    public static class_2960 ID = class_2960.method_60654("clipboard_type");

    ClipboardType(String file) {
        this.file = file;
    }

    @Override
    public @NotNull String method_15434() {
        return name().toLowerCase(Locale.ROOT);
    }
}
