package com.zurrtum.create.infrastructure.fluids;

import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3611;

public class BucketFluidInventory extends FluidItemInventoryWrapper {
    public static final int CAPACITY = 81000;

    @Override
    public int getMaxAmountPerStack() {
        return CAPACITY;
    }

    public class_1799 toFillBucket(FluidStack stack) {
        return stack.getFluid().method_15774().method_7854();
    }

    public class_3611 toFluid() {
        return ((class_1755) this.stack.method_7909()).field_7905;
    }

    @Override
    public boolean canInsert() {
        class_1792 item = stack.method_7909();
        return item == class_1802.field_8550 || item == class_1802.field_8162;
    }

    @Override
    public boolean canExtract() {
        class_1792 item = stack.method_7909();
        return item != class_1802.field_8550 && item != class_1802.field_8162;
    }

    @Override
    public int insert(FluidStack stack) {
        return insert(stack, stack.getAmount());
    }

    @Override
    public int insert(FluidStack stack, int maxAmount) {
        if (!canInsert() || maxAmount < CAPACITY) {
            return 0;
        }
        class_1799 bucket = toFillBucket(stack);
        if (bucket.method_7960()) {
            return 0;
        }
        this.stack = bucket;
        return CAPACITY;
    }

    @Override
    public boolean preciseInsert(FluidStack stack) {
        return insert(stack) == CAPACITY;
    }

    @Override
    public int count(FluidStack stack) {
        class_1792 item = this.stack.method_7909();
        if (item == class_1802.field_8550 || item == class_1802.field_8162 || stack.getFluid() != toFluid()) {
            return 0;
        }
        return CAPACITY;
    }

    @Override
    public int count(FluidStack stack, int maxAmount) {
        if (maxAmount < CAPACITY) {
            return 0;
        }
        return count(stack);
    }

    @Override
    public int countSpace(FluidStack stack) {
        class_1799 bucket = toFillBucket(stack);
        if (bucket.method_7960()) {
            return 0;
        }
        return canInsert() ? CAPACITY : 0;
    }

    @Override
    public int countSpace(FluidStack stack, int maxAmount) {
        if (maxAmount < CAPACITY) {
            return 0;
        }
        return countSpace(stack);
    }

    @Override
    public int extract(FluidStack stack) {
        return extract(stack, stack.getAmount());
    }

    @Override
    public int extract(FluidStack stack, int maxAmount) {
        if (!canExtract() || maxAmount != CAPACITY || stack.getFluid() != toFluid()) {
            return 0;
        }
        this.stack = class_1802.field_8550.method_7854();
        return CAPACITY;
    }

    @Override
    public FluidStack extractAny(int maxAmount) {
        if (!canExtract() || maxAmount != CAPACITY) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = new FluidStack(toFluid(), CAPACITY);
        stack = class_1802.field_8550.method_7854();
        return fluid;
    }

    @Override
    public boolean preciseExtract(FluidStack stack) {
        return extract(stack) == CAPACITY;
    }

    @Override
    public FluidStack getStack() {
        class_1792 item = stack.method_7909();
        if (item == class_1802.field_8550 || item == class_1802.field_8162) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(toFluid(), CAPACITY);
    }

    @Override
    public void setStack(FluidStack stack) {
        if (stack.getAmount() >= CAPACITY) {
            this.stack = toFillBucket(stack);
        } else {
            this.stack = class_1802.field_8550.method_7854();
        }
    }

    @Override
    public FluidStack removeStack() {
        class_1792 item = stack.method_7909();
        if (item == class_1802.field_8550 || item == class_1802.field_8162) {
            return FluidStack.EMPTY;
        }
        stack = class_1802.field_8550.method_7854();
        return new FluidStack(toFluid(), CAPACITY);
    }

    @Override
    public FluidStack removeStackWithAmount(int amount) {
        if (amount != CAPACITY) {
            return FluidStack.EMPTY;
        }
        return removeStack();
    }
}
