package com.zurrtum.create.infrastructure.packet.c2s;

import com.zurrtum.create.AllHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_3244;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public record ControlsInputPacket(
    List<Integer> activatedButtons, boolean press, int contraptionEntityId, class_2338 controlsPos, boolean stopControlling
) implements C2SPacket {
    public static final class_9139<ByteBuf, ControlsInputPacket> CODEC = class_9139.method_56906(
        CatnipStreamCodecBuilders.list(class_9135.field_48550),
        ControlsInputPacket::activatedButtons,
        class_9135.field_48547,
        ControlsInputPacket::press,
        class_9135.field_49675,
        ControlsInputPacket::contraptionEntityId,
        class_2338.field_48404,
        ControlsInputPacket::controlsPos,
        class_9135.field_48547,
        ControlsInputPacket::stopControlling,
        ControlsInputPacket::new
    );

    public ControlsInputPacket(
        Collection<Integer> activatedButtons,
        boolean press,
        int contraptionEntityId,
        class_2338 controlsPos,
        boolean stopControlling
    ) {
        // given list is reused, copy it
        this(List.copyOf(activatedButtons), press, contraptionEntityId, controlsPos, stopControlling);
    }

    @Override
    public class_9145<ControlsInputPacket> method_65080() {
        return AllPackets.CONTROLS_INPUT;
    }

    @Override
    public BiConsumer<class_3244, ControlsInputPacket> callback() {
        return AllHandle::onControlsInput;
    }
}
