package com.zurrtum.create.infrastructure.packet.c2s;

import com.zurrtum.create.AllHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import java.util.function.BiConsumer;
import net.minecraft.class_3244;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public record SchematicUploadPacket(int code, long size, String schematic, byte[] data) implements C2SPacket {
    public static final int BEGIN = 0;
    public static final int WRITE = 1;
    public static final int FINISH = 2;

    public static final class_9139<class_9129, SchematicUploadPacket> CODEC = class_9139.method_56905(
        class_9135.field_48550,
        SchematicUploadPacket::code,
        class_9135.field_48551,
        SchematicUploadPacket::size,
        CatnipStreamCodecBuilders.nullable(class_9135.method_56364(256)),
        SchematicUploadPacket::schematic,
        CatnipStreamCodecBuilders.nullable(class_9135.method_56895(Integer.MAX_VALUE)),
        SchematicUploadPacket::data,
        SchematicUploadPacket::new
    );

    public static SchematicUploadPacket begin(String schematic, long size) {
        return new SchematicUploadPacket(BEGIN, size, schematic, null);
    }

    public static SchematicUploadPacket write(String schematic, byte[] data) {
        return new SchematicUploadPacket(WRITE, 0, schematic, data);
    }

    public static SchematicUploadPacket finish(String schematic) {
        return new SchematicUploadPacket(FINISH, 0, schematic, null);
    }

    @Override
    public boolean runInMain() {
        return true;
    }

    @Override
    public class_9145<SchematicUploadPacket> method_65080() {
        return AllPackets.UPLOAD_SCHEMATIC;
    }

    @Override
    public BiConsumer<class_3244, SchematicUploadPacket> callback() {
        return AllHandle::onSchematicUpload;
    }
}
