package com.zurrtum.create.infrastructure.packet.s2c;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.trains.signal.EdgeGroupColor;
import io.netty.buffer.ByteBuf;
import org.apache.logging.log4j.util.TriConsumer;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_4844;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public record SignalEdgeGroupPacket(List<UUID> ids, List<EdgeGroupColor> colors, boolean add) implements S2CPacket {
    public static final class_9139<ByteBuf, SignalEdgeGroupPacket> CODEC = class_9139.method_56436(
        CatnipStreamCodecBuilders.list(class_4844.field_48453),
        SignalEdgeGroupPacket::ids,
        CatnipStreamCodecBuilders.list(EdgeGroupColor.STREAM_CODEC),
        SignalEdgeGroupPacket::colors,
        class_9135.field_48547,
        SignalEdgeGroupPacket::add,
        SignalEdgeGroupPacket::new
    );

    public SignalEdgeGroupPacket(UUID id, EdgeGroupColor color) {
        this(ImmutableList.of(id), ImmutableList.of(color), true);
    }

    @Override
    public <T> TriConsumer<AllClientHandle<T>, T, SignalEdgeGroupPacket> callback() {
        return AllClientHandle::onSignalEdgeGroup;
    }

    @Override
    public class_9145<SignalEdgeGroupPacket> method_65080() {
        return AllPackets.SYNC_EDGE_GROUP;
    }
}
