package com.zurrtum.create.mixin;

import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.api.contraption.BlockMovementChecks.CheckResult;
import dan200.computercraft.shared.integration.CreateIntegration;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlock;
import net.minecraft.class_2248;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(CreateIntegration.class)
public class CreateIntegrationMixin {
    @Inject(method = "setup()V", at = @At("HEAD"), cancellable = true, remap = false)
    private static void setup(CallbackInfo ci) {
        BlockMovementChecks.registerAttachedCheck((state, world, pos, direction) -> {
            class_2248 block = state.method_26204();
            if (block instanceof WirelessModemBlock) {
                return CheckResult.of(state.method_11654(WirelessModemBlock.field_10927) == direction);
            } else {
                return block instanceof CableBlock ? CheckResult.of(state.method_11654(CableBlock.MODEM).getFacing() == direction) : CheckResult.PASS;
            }
        });
        ci.cancel();
    }
}
