package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.AllSynchedDatas;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_2945;
import net.minecraft.class_9221;

@Mixin(class_2945.class)
public class DataTrackerMixin {
    @Final
    @Shadow
    private class_9221 trackedEntity;

    @Inject(method = "writeUpdatedEntries(Ljava/util/List;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/data/DataTracked;onTrackedDataSet(Lnet/minecraft/entity/data/TrackedData;)V"))
    private void onTrackedDataSet(
        List<class_2945.class_7834<?>> entries,
        CallbackInfo ci,
        @Local class_2945.class_7834<?> serializedEntry
    ) {
        AllSynchedDatas.onData(trackedEntity, serializedEntry);
    }
}
