package com.zurrtum.create.mixin;

import com.zurrtum.create.infrastructure.items.BaseInventory;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_1263.class)
public interface InventoryMixin extends BaseInventory {
    @Shadow
    void setStack(int slot, class_1799 stack);

    @Shadow
    int size();

    @Shadow
    int getMaxCount(class_1799 stack);

    @Shadow
    class_1799 getStack(int slot);

    @Shadow
    boolean isValid(int slot, class_1799 stack);

    @Shadow
    void markDirty();

    @Override
    default void create$setStack(int slot, class_1799 stack) {
        setStack(slot, stack);
    }

    @Override
    default int create$size() {
        return size();
    }

    @Override
    default int create$getMaxCount(class_1799 stack) {
        return getMaxCount(stack);
    }

    @Override
    default class_1799 create$getStack(int slot) {
        return getStack(slot);
    }

    @Override
    default boolean create$isValid(int slot, class_1799 stack) {
        return isValid(slot, stack);
    }

    @Override
    default void create$markDirty() {
        markDirty();
    }
}
