package com.zurrtum.create.mixin;

import com.zurrtum.create.infrastructure.config.SyncConfigTask;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Queue;
import net.minecraft.class_8605;
import net.minecraft.class_8610;

@Mixin(class_8610.class)
public abstract class ServerConfigurationNetworkHandlerMixin {
    @Shadow
    @Final
    private Queue<class_8605> tasks;

    @Shadow
    protected abstract void onTaskFinished(class_8605.class_8606 key);

    @Inject(method = "queueSendResourcePackTask()V", at = @At("TAIL"))
    private void queueSendResourcePackTask(CallbackInfo ci) {
        tasks.add(new SyncConfigTask(this::onTaskFinished));
    }
}
