package com.zurrtum.create;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.class_8110;

public class AllDamageSources {
    private static final Map<class_5455, AllDamageSources> ALL = new IdentityHashMap<>();

    public static AllDamageSources get(class_5455 registryManager) {
        return ALL.get(registryManager);
    }

    public static AllDamageSources get(class_1937 world) {
        return ALL.get(world.method_30349());
    }

    public class_2378<class_8110> registry;
    public class_1282 crush;
    public class_1282 cuckoo_surprise;
    public class_1282 fan_fire;
    public class_1282 fan_lava;
    public class_1282 drill;
    public class_1282 roller;
    public class_1282 saw;

    public AllDamageSources(class_5455 registryManager) {
        registry = registryManager.method_30530(class_7924.field_42534);
        crush = create(AllDamageTypes.CRUSH);
        cuckoo_surprise = create(AllDamageTypes.CUCKOO_SURPRISE);
        fan_fire = create(AllDamageTypes.FAN_FIRE);
        fan_lava = create(AllDamageTypes.FAN_LAVA);
        drill = create(AllDamageTypes.DRILL);
        roller = create(AllDamageTypes.ROLLER);
        saw = create(AllDamageTypes.SAW);
    }

    public class_1282 create(class_5321<class_8110> type) {
        return new class_1282(registry.method_46747(type));
    }

    public class_1282 potatoCannon(class_1297 causingEntity, class_1297 directEntity) {
        return new class_1282(registry.method_46747(AllDamageTypes.POTATO_CANNON), causingEntity, directEntity);
    }

    public class_1282 runOver(class_1297 entity) {
        return new class_1282(registry.method_46747(AllDamageTypes.RUN_OVER), entity);
    }

    public static void register(class_5455 registryManager) {
        ALL.put(registryManager, new AllDamageSources(registryManager));
    }
}
