package com.zurrtum.create;

import static com.zurrtum.create.Create.MOD_ID;
import static net.minecraft.class_3419.*;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public class AllSoundEvents {
    public static final SoundEntry SCHEMATICANNON_LAUNCH_BLOCK = register("schematicannon_launch_block", field_15245, .1f, 1.1f);
    public static final SoundEntry SCHEMATICANNON_FINISH = register("schematicannon_finish", field_15245, 1, .7f);
    public static final SoundEntry DEPOT_SLIDE = register("depot_slide", field_15245, .125f, 1.5f);
    public static final SoundEntry DEPOT_PLOP = register("depot_plop", field_15245, .25f, 1.25f);
    public static final SoundEntry FUNNEL_FLAP = register("funnel_flap", field_15245, .125f, 1.5f, .0425f, .75f);
    public static final SoundEntry PACKAGER = register("packager", field_15245, 0.5f, 0.75f);
    public static final SoundEntry SLIME_ADDED = register("slime_added", field_15245);
    public static final SoundEntry MECHANICAL_PRESS_ACTIVATION = register("mechanical_press_activation", field_15245, .125f, 1f, .5f, 1f);
    public static final SoundEntry MECHANICAL_PRESS_ACTIVATION_ON_BELT = register("mechanical_press_activation_belt", field_15245, .75f, 1f, .15f, .75f);
    public static final SoundEntry MIXING = register("mixing", field_15245, .125f, .5f, .125f, .5f);
    public static final SoundEntry SPOUTING = register("spout", field_15245);
    public static final SoundEntry CRANKING = register("cranking", field_15245, .075f, .5f, .025f, .5f);
    public static final SoundEntry WORLDSHAPER_PLACE = register("worldshaper_place", field_15248);
    public static final SoundEntry SCROLL_VALUE = register("scroll_value", field_15248, .124f, 1f);
    public static final SoundEntry CONFIRM = register("confirm", field_15248, 0.5f, 0.8f);
    public static final SoundEntry CONFIRM_2 = register("confirm_2", field_15248);
    public static final SoundEntry DENY = register("deny", field_15248, 1f, 0.5f);
    public static final SoundEntry COGS = register("cogs", field_15245);
    public static final SoundEntry FWOOMP = register("fwoomp", field_15248);
    public static final SoundEntry CARDBOARD_SWORD = register("cardboard_bonk", field_15248);
    public static final SoundEntry FROGPORT_OPEN = register("frogport_open", field_15245, 1f, 2f);
    public static final SoundEntry FROGPORT_CLOSE = register("frogport_close", field_15245);
    public static final SoundEntry FROGPORT_CATCH = register("frogport_catch", field_15245);
    public static final SoundEntry STOCK_LINK = register("stock_link", field_15245);
    public static final SoundEntry FROGPORT_DEPOSIT = register("frogport_deposit", field_15245);
    public static final SoundEntry POTATO_HIT = register("potato_hit", field_15248, .75f, .75f, .75f, 1.25f);
    public static final SoundEntry CONTRAPTION_ASSEMBLE = register("contraption_assemble", field_15245, .5f, .5f, .045f, .74f);
    public static final SoundEntry CONTRAPTION_DISASSEMBLE = register("contraption_disassemble", field_15245, .35f, .75f);
    public static final SoundEntry WRENCH_ROTATE = register("wrench_rotate", field_15245, .25f, 1.25f);
    public static final SoundEntry WRENCH_REMOVE = register("wrench_remove", field_15245, .25f, .75f, .25f, .75f);
    public static final SoundEntry PACKAGE_POP = register("package_pop", field_15245, .75f, 1f, .25f, 1.15f);
    public static final SoundEntry CRAFTER_CLICK = register("crafter_click", field_15245, .25f, 1, .125f, 1);
    public static final SoundEntry CRAFTER_CRAFT = register("crafter_craft", field_15245, .125f, .75f);
    public static final SoundEntry SANDING_SHORT = register("sanding_short", field_15245);
    public static final SoundEntry SANDING_LONG = register("sanding_long", field_15245);
    public static final SoundEntry CONTROLLER_CLICK = register("controller_click", field_15245, .35f, 1f);
    public static final SoundEntry CONTROLLER_PUT = register("controller_put", field_15245);
    public static final SoundEntry CONTROLLER_TAKE = register("controller_take", field_15245);
    public static final SoundEntry SAW_ACTIVATE_WOOD = register("saw_activate_wood", field_15245, .75f, 1.5f);
    public static final SoundEntry SAW_ACTIVATE_STONE = register("saw_activate_stone", field_15245, .125f, 1.25f);
    public static final SoundEntry BLAZE_MUNCH = register("blaze_munch", field_15245, .5f, 1f);
    public static final SoundEntry ITEM_HATCH = register("item_hatch", field_15245, .25f, 1.4f, .75f, 1.15f);
    public static final SoundEntry CRUSHING_1 = register("crushing_1", field_15245);
    public static final SoundEntry CRUSHING_2 = register("crushing_2", field_15245);
    public static final SoundEntry CRUSHING_3 = register("crushing_3", field_15245);
    public static final SoundEntry PECULIAR_BELL_USE = register("peculiar_bell_use", field_15245);
    public static final SoundEntry DESK_BELL_USE = register("desk_bell", field_15245);
    public static final SoundEntry WHISTLE_HIGH = register("whistle_high", field_15247);
    public static final SoundEntry WHISTLE_MEDIUM = register("whistle", field_15247);
    public static final SoundEntry WHISTLE_LOW = register("whistle_low", field_15247);
    public static final SoundEntry STEAM = register("steam", field_15254);
    public static final SoundEntry TRAIN = register("train", field_15254);
    public static final SoundEntry TRAIN2 = register("train2", field_15254);
    public static final SoundEntry TRAIN3 = register("train3", field_15254);
    public static final SoundEntry WHISTLE_TRAIN = register("whistle_train", field_15247);
    public static final SoundEntry WHISTLE_TRAIN_LOW = register("whistle_train_low", field_15247);
    public static final SoundEntry WHISTLE_TRAIN_MANUAL = register("whistle_train_manual", field_15254);
    public static final SoundEntry WHISTLE_TRAIN_MANUAL_LOW = register("whistle_train_manual_low", field_15254);
    public static final SoundEntry WHISTLE_TRAIN_MANUAL_END = register("whistle_train_manual_end", field_15254);
    public static final SoundEntry WHISTLE_TRAIN_MANUAL_LOW_END = register("whistle_train_manual_low_end", field_15254);
    public static final SoundEntry WHISTLE_CHIFF = register("chiff", field_15247);
    public static final SoundEntry HAUNTED_BELL_CONVERT = register("haunted_bell_convert", field_15245);
    public static final SoundEntry HAUNTED_BELL_USE = register("haunted_bell_use", field_15245);
    public static final SoundEntry STOCK_TICKER_REQUEST = register("stock_ticker_request", field_15245);
    public static final SoundEntry STOCK_TICKER_TRADE = register("stock_ticker_trade", field_15245);
    public static final SoundEntry CLIPBOARD_CHECKMARK = register("clipboard_check", field_15245);
    public static final SoundEntry CLIPBOARD_ERASE = register("clipboard_erase", field_15245);

    private static SoundEntry register(String name, class_3419 category, float... data) {
        if (data.length == 0) {
            data = new float[]{1f, 1f};
        }
        class_2960 id = class_2960.method_60655(MOD_ID, name);
        int count = data.length / 2;
        CompiledSoundEvent[] compiledEvents = new CompiledSoundEvent[count];
        class_3414 event = class_2378.method_10230(class_7923.field_41172, id, class_3414.method_47908(id));
        compiledEvents[0] = new CompiledSoundEvent(event, data[0], data[1]);
        for (int i = 2, j = 1; j < count; i += 2, j++) {
            event = class_2378.method_10230(class_7923.field_41172, id.method_48331("_compounded_" + j), class_3414.method_47908(id));
            compiledEvents[j] = new CompiledSoundEvent(event, data[i], data[i + 1]);
        }
        return new SoundEntry(category, compiledEvents);
    }

    public record SoundEntry(class_3419 category, CompiledSoundEvent[] sounds) {
        public class_3414 getMainEvent() {
            return sounds[0].event();
        }

        public void play(class_1937 world, class_1657 entity, double x, double y, double z, float volume, float pitch) {
            for (CompiledSoundEvent sound : sounds) {
                sound.play(world, entity, x, y, z, category, volume, pitch);
            }
        }

        public void playAt(class_1937 world, double x, double y, double z, float volume, float pitch, boolean fade) {
            for (CompiledSoundEvent sound : sounds) {
                sound.playAt(world, x, y, z, category, volume, pitch, fade);
            }
        }

        public void playOnServer(class_1937 world, class_2382 pos) {
            playOnServer(world, pos, 1, 1);
        }

        public void playOnServer(class_1937 world, class_2382 pos, float volume, float pitch) {
            play(world, null, pos, volume, pitch);
        }

        public void play(class_1937 world, class_1657 entity, class_2382 pos) {
            play(world, entity, pos, 1, 1);
        }

        public void playFrom(class_1297 entity) {
            playFrom(entity, 1, 1);
        }

        public void playFrom(class_1297 entity, float volume, float pitch) {
            if (!entity.method_5701())
                play(entity.method_37908(), null, entity.method_24515(), volume, pitch);
        }

        public void play(class_1937 world, class_1657 entity, class_2382 pos, float volume, float pitch) {
            play(world, entity, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, volume, pitch);
        }

        public void play(class_1937 world, class_1657 entity, class_243 pos, float volume, float pitch) {
            play(world, entity, pos.method_10216(), pos.method_10214(), pos.method_10215(), volume, pitch);
        }

        public void playAt(class_1937 world, class_2382 pos, float volume, float pitch, boolean fade) {
            playAt(world, pos.method_10263() + .5, pos.method_10264() + .5, pos.method_10260() + .5, volume, pitch, fade);
        }

        public void playAt(class_1937 world, class_243 pos, float volume, float pitch, boolean fade) {
            playAt(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), volume, pitch, fade);
        }
    }

    private record CompiledSoundEvent(class_3414 event, float volume, float pitch) {
        public void play(class_1937 world, class_1657 entity, double x, double y, double z, class_3419 category, float volume, float pitch) {
            world.method_43128(entity, x, y, z, event(), category, volume() * volume, pitch() * pitch);
        }

        public void playAt(class_1937 world, double x, double y, double z, class_3419 category, float volume, float pitch, boolean fade) {
            world.method_8486(x, y, z, event(), category, volume() * volume, pitch() * pitch, fade);
        }
    }

    public static void register() {
    }
}
