package com.zurrtum.create;

import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import com.zurrtum.create.content.trains.entity.CarriageSyncData;
import com.zurrtum.create.content.trains.entity.CarriageSyncDataSerializer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1453;
import net.minecraft.class_1498;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_7834;
import net.minecraft.class_4844;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9221;
import net.minecraft.class_9227;
import net.minecraft.entity.data.*;
import org.apache.logging.log4j.util.TriConsumer;

import java.util.*;
import java.util.function.*;

public class AllSynchedDatas {
    private static final Map<Class<?>, SynchedData> ALL = new IdentityHashMap<>();
    private static final Map<Class<?>, Optional<SynchedData>> ON_DATA = new IdentityHashMap<>();
    public static final List<class_2941<?>> HANDLERS = new ArrayList<>();
    public static final class_2941<Optional<MinecartController>> MINECART_CONTROLLER_HANDLER = register(MinecartController.PACKET_CODEC.method_56433(
        class_9135::method_56382));
    public static final class_2941<Optional<UUID>> OPTIONAL_UUID_HANDLER = register(class_4844.field_48453.method_56433(class_9135::method_56382));
    public static final class_2941<Optional<List<class_1799>>> CAPTURE_DROPS_HANDLER = register(class_1799.field_48349.method_56433(class_9135.method_56363())
        .method_56433(class_9135::method_56382));
    public static final class_2941<CarriageSyncData> CARRIAGE_DATA_HANDLER = register(CarriageSyncDataSerializer::new);
    public static final class_2941<Optional<class_243>> OPTIONAL_VEC3D_HANDLER = register(class_243.field_52694.method_56433(class_9135::method_56382));
    public static final Entry<Integer> HAUNTING = register(class_1498.class, class_2943.field_13327, 0);
    public static final Entry<String> ITEM_TYPE = register(class_1542.class, class_2943.field_13326, "");
    public static final Entry<Integer> ITEM_TIME = register(class_1542.class, class_2943.field_13327, 0);
    public static final Entry<Optional<class_2338>> BYPASS_CRUSHING_WHEEL = register(
        class_1542.class,
        class_2943.field_13315,
        Optional.empty()
    );
    public static final Entry<Optional<MinecartController>> MINECART_CONTROLLER = register(
        class_1688.class,
        MINECART_CONTROLLER_HANDLER,
        Optional.empty(),
        (entity, value) -> value.ifPresent(controller -> controller.setCart(entity))
    );
    public static final Entry<Integer> VISUAL_BACKTANK_AIR = register(class_1657.class, class_2943.field_13327, 0);
    public static final Entry<Boolean> FIRE_IMMUNE = register(class_1657.class, class_2943.field_13323, false);
    public static final Entry<Boolean> HEAVY_BOOTS = register(class_1657.class, class_2943.field_13323, false);
    public static final Entry<Boolean> CRUSH_DROP = register(class_1297.class, class_2943.field_13323, false);
    public static final Entry<Optional<List<class_1799>>> CAPTURE_DROPS = register(class_1297.class, CAPTURE_DROPS_HANDLER, Optional.empty());
    public static final Entry<Boolean> CONTRAPTION_GROUNDED = register(class_1297.class, class_2943.field_13323, false);
    public static final Entry<Optional<class_243>> CONTRAPTION_DISMOUNT_LOCATION = register(class_1309.class, OPTIONAL_VEC3D_HANDLER, Optional.empty());
    public static final Entry<Optional<class_243>> CONTRAPTION_MOUNT_LOCATION = register(class_1657.class, OPTIONAL_VEC3D_HANDLER, Optional.empty());
    public static final Entry<Boolean> IS_USING_LECTERN_CONTROLLER = register(class_1657.class, class_2943.field_13323, false);
    public static final Entry<class_2487> TOOLBOX = register(class_1657.class, class_2943.field_13318, new class_2487());
    public static final Entry<Integer> LAST_OVERRIDE_LIMB_SWING_UPDATE = register(class_1657.class, class_2943.field_13327, -1);
    public static final Entry<Float> OVERRIDE_LIMB_SWING = register(class_1657.class, class_2943.field_13320, 0F);
    public static final Entry<Boolean> PARROT_TRAIN_HAT = register(class_1453.class, class_2943.field_13323, false);

    private static <T> Entry<T> register(Class<? extends class_9221> type, class_2941<T> handler, T def) {
        return register(type, handler, def, null);
    }

    private static <E extends class_9221, T> Entry<T> register(Class<E> type, class_2941<T> handler, T def, BiConsumer<E, T> onData) {
        return ALL.computeIfAbsent(type, SynchedData::new).add(handler, def, onData);
    }

    private static <T> class_2941<T> register(class_9139<? super class_9129, T> codec) {
        class_2941<T> handler = class_2941.method_56031(codec);
        HANDLERS.add(handler);
        return handler;
    }

    private static <T> class_2941<T> register(Supplier<class_2941<T>> factory) {
        class_2941<T> handler = factory.get();
        HANDLERS.add(handler);
        return handler;
    }

    public static SynchedData get(Class<?> type) {
        return ALL.computeIfAbsent(type, SynchedData::new);
    }

    public static void onData(class_9221 entity, class_7834<?> entry) {
        ON_DATA.computeIfAbsent(entity.getClass(), AllSynchedDatas::getParentOrEmpty).ifPresent(data -> data.onData(entity, entry));
    }

    private static Optional<SynchedData> getParentOrEmpty(Class<?> type) {
        while (type != class_1297.class) {
            type = type.getSuperclass();
            Optional<SynchedData> value = ON_DATA.get(type);
            if (value != null) {
                return value;
            }
        }
        return Optional.empty();
    }

    public static void register() {
    }

    public static class SynchedData {
        private final Class<?> type;
        private final Deque<Entry<?>> datas = new ArrayDeque<>();
        private List<Consumer<class_2945.class_2946<?>[]>> actions;
        private Int2ObjectMap<BiConsumer<? extends class_9221, ?>> listeners;
        private int size;

        public SynchedData(Class<?> type) {
            this.type = type;
        }

        public <E extends class_9221, T> Entry<T> add(class_2941<T> handler, T def, BiConsumer<E, T> onData) {
            Entry<T> entry = new Entry<>(handler, def, onData);
            datas.add(entry);
            return entry;
        }

        private void preparse(int index, SynchedData parent) {
            if (parent != null) {
                if (datas.isEmpty()) {
                    datas.addAll(parent.datas);
                } else {
                    Iterator<Entry<?>> iterator = parent.datas.descendingIterator();
                    while (iterator.hasNext()) {
                        datas.addFirst(iterator.next());
                    }
                }
            }
            actions = new ArrayList<>(datas.size());
            for (Entry<?> task : datas) {
                if (task.listener != null) {
                    if (listeners == null) {
                        listeners = new Int2ObjectOpenHashMap<>();
                        ON_DATA.put(type, Optional.of(this));
                    }
                    listeners.put(index, task.listener);
                }
                actions.add(task.add(type, index++));
            }
            size = index;
        }

        public int preparse(class_9227 map, BiFunction<class_9227, Class<?>, Integer> factory) {
            if (size != 0) {
                return size;
            }
            Deque<SynchedData> parents = new ArrayDeque<>();
            SynchedData parent = null;
            Class<?> key = type;
            while (key != class_1297.class) {
                key = key.getSuperclass();
                SynchedData data = ALL.get(key);
                if (data != null) {
                    if (data.size != 0) {
                        parent = data;
                        break;
                    }
                    parents.addFirst(data);
                }
            }
            while (!parents.isEmpty()) {
                SynchedData data = parents.pollFirst();
                data.preparse(factory.apply(map, data.type), parent);
                parent = data;
            }
            preparse(factory.apply(map, type), parent);
            return size;
        }

        public void register(class_2945.class_2946<?>[] entries) {
            actions.forEach(action -> action.accept(entries));
        }

        @SuppressWarnings("unchecked")
        protected <E extends class_9221, T> void onData(E entity, class_7834<T> serializedEntry) {
            if (listeners == null) {
                return;
            }
            BiConsumer<E, T> callback = (BiConsumer<E, T>) listeners.get(serializedEntry.comp_1115());
            if (callback != null) {
                callback.accept(entity, serializedEntry.comp_1117());
            }
        }
    }

    public static class Entry<T> {
        private final class_2941<T> handler;
        private final Supplier<T> def;
        private final BiConsumer<? extends class_9221, T> listener;
        private BiFunction<Class<?>, Integer, Consumer<class_2945.class_2946<?>[]>> add = this::firstAdd;
        private Function<class_1297, T> get;
        private TriConsumer<class_1297, T, Boolean> set;

        @SuppressWarnings("unchecked")
        private Entry(class_2941<T> handler, T def, BiConsumer<? extends class_9221, T> listener) {
            this.handler = handler;
            if (def instanceof class_2487 nbt) {
                this.def = () -> (T) nbt.method_10553();
            } else {
                this.def = () -> def;
            }
            this.listener = listener;
        }

        private Consumer<class_2945.class_2946<?>[]> firstAdd(Class<?> type, int id) {
            class_2940<T> data = handler.method_12717(id);
            get = target -> target.method_5841().method_12789(data);
            set = (target, value, force) -> target.method_5841().method_49743(data, value, force);
            add = (otherType, otherId) -> {
                IdentityHashMap<Class<?>, class_2940<T>> map = new IdentityHashMap<>();
                map.put(type, data);
                get = target -> target.method_5841().method_12789(map.get(target.getClass()));
                set = (target, value, force) -> target.method_5841().method_49743(map.get(target.getClass()), value, force);
                add = (addType, addId) -> {
                    class_2940<T> addData = handler.method_12717(addId);
                    map.put(addType, addData);
                    return entries -> entries[addId] = new class_2945.class_2946<>(addData, def.get());
                };
                return add.apply(otherType, otherId);
            };
            return entries -> entries[id] = new class_2945.class_2946<>(data, def.get());
        }

        public Consumer<class_2945.class_2946<?>[]> add(Class<?> type, int id) {
            return add.apply(type, id);
        }

        public T get(class_1297 target) {
            return get.apply(target);
        }

        public void set(class_1297 target, T value) {
            set.accept(target, value, false);
        }

        public void set(class_1297 target, T value, boolean force) {
            set.accept(target, value, force);
        }
    }
}
