package com.zurrtum.create.api.behaviour.interaction;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.Schedule;
import com.zurrtum.create.content.trains.schedule.ScheduleItem;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499.class_3501;

/**
 * Partial interaction behavior implementation that allows blocks to act as conductors on trains, like Blaze Burners.
 */
public abstract class ConductorBlockInteractionBehavior extends MovingInteractionBehaviour {
    /**
     * Check if the given state is capable of being a conductor.
     */
    public abstract boolean isValidConductor(class_2680 state);

    /**
     * Called when the conductor's schedule has changed.
     *
     * @param hasSchedule      true if the schedule was set, false if it was removed
     * @param blockStateSetter a consumer that will change the BlockState of this conductor on the contraption
     */
    protected void onScheduleUpdate(boolean hasSchedule, class_2680 currentBlockState, Consumer<class_2680> blockStateSetter) {
    }

    @Override
    public final boolean handlePlayerInteraction(
        class_1657 player,
        class_1268 activeHand,
        class_2338 localPos,
        AbstractContraptionEntity contraptionEntity
    ) {
        if (!(contraptionEntity instanceof CarriageContraptionEntity carriageEntity))
            return false;
        if (activeHand == class_1268.field_5810)
            return false;
        Contraption contraption = carriageEntity.getContraption();
        if (!(contraption instanceof CarriageContraption carriageContraption))
            return false;

        class_3501 info = carriageContraption.getBlocks().get(localPos);
        if (info == null || !this.isValidConductor(info.comp_1342()))
            return false;

        class_2350 assemblyDirection = carriageContraption.getAssemblyDirection();
        class_1799 itemInHand = player.method_5998(activeHand);
        for (class_2350 direction : Iterate.directionsInAxis(assemblyDirection.method_10166())) {
            if (!carriageContraption.inControl(localPos, direction))
                continue;

            Train train = carriageEntity.getCarriage().train;
            if (train == null)
                return false;
            if (player.method_37908().field_9236)
                return true;

            if (train.runtime.getSchedule() != null) {
                if (train.runtime.paused && !train.runtime.completed) {
                    train.runtime.paused = false;
                    AllSoundEvents.CONFIRM.playOnServer(player.method_37908(), player.method_24515(), 1, 1);
                    player.method_7353(class_2561.method_43471("create.schedule.continued"), true);
                    return true;
                }

                if (!itemInHand.method_7960()) {
                    AllSoundEvents.DENY.playOnServer(player.method_37908(), player.method_24515(), 1, 1);
                    player.method_7353(class_2561.method_43471("create.schedule.remove_with_empty_hand"), true);
                    return true;
                }

                player.method_37908().method_8396(
                    null,
                    player.method_24515(),
                    class_3417.field_15197,
                    class_3419.field_15248,
                    .2f,
                    1f + player.method_37908().field_9229.method_43057()
                );
                player.method_7353(
                    class_2561.method_43471(train.runtime.isAutoSchedule ? "create.schedule.auto_removed_from_train" : "create.schedule.removed_from_train"),
                    true
                );
                player.method_6122(activeHand, train.runtime.returnSchedule(player.method_56673()));
                this.onScheduleUpdate(false, info.comp_1342(), newBlockState -> setBlockState(localPos, contraptionEntity, newBlockState));
                return true;
            }

            if (!itemInHand.method_31574(AllItems.SCHEDULE))
                return true;

            Schedule schedule = ScheduleItem.getSchedule(player.method_56673(), itemInHand);
            if (schedule == null)
                return false;

            if (schedule.entries.isEmpty()) {
                AllSoundEvents.DENY.playOnServer(player.method_37908(), player.method_24515(), 1, 1);
                player.method_7353(class_2561.method_43471("create.schedule.no_stops"), true);
                return true;
            }
            this.onScheduleUpdate(true, info.comp_1342(), newBlockState -> setBlockState(localPos, contraptionEntity, newBlockState));
            train.runtime.setSchedule(schedule, false);
            AllAdvancements.CONDUCTOR.trigger((class_3222) player);
            AllSoundEvents.CONFIRM.playOnServer(player.method_37908(), player.method_24515(), 1, 1);
            player.method_7353(class_2561.method_43471("create.schedule.applied_to_train").method_27692(class_124.field_1060), true);
            itemInHand.method_7934(1);
            player.method_6122(activeHand, itemInHand.method_7960() ? class_1799.field_8037 : itemInHand);
            return true;
        }

        player.method_7353(class_2561.method_43471("create.schedule.non_controlling_seat"), true);
        AllSoundEvents.DENY.playOnServer(player.method_37908(), player.method_24515(), 1, 1);
        return true;
    }

    private void setBlockState(class_2338 localPos, AbstractContraptionEntity contraption, class_2680 newState) {
        class_3501 info = contraption.getContraption().getBlocks().get(localPos);
        if (info != null) {
            setContraptionBlockData(contraption, localPos, new class_3501(info.comp_1341(), newState, info.comp_1343()));
        }
    }

    /**
     * Implementation used for Blaze Burners. May be reused by addons if applicable.
     */
    public static class BlazeBurner extends ConductorBlockInteractionBehavior {
        @Override
        public boolean isValidConductor(class_2680 state) {
            return state.method_11654(BlazeBurnerBlock.HEAT_LEVEL) != BlazeBurnerBlock.HeatLevel.NONE;
        }
    }
}
