package com.zurrtum.create.api.contraption.storage.fluid;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.api.registry.SimpleRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public abstract class MountedFluidStorageType<T extends MountedFluidStorage> {
    public static final Codec<MountedFluidStorageType<?>> CODEC = CreateRegistries.MOUNTED_FLUID_STORAGE_TYPE.method_39673();
    public static final SimpleRegistry<class_2248, MountedFluidStorageType<?>> REGISTRY = SimpleRegistry.create();

    public final MapCodec<? extends T> codec;

    protected MountedFluidStorageType(MapCodec<? extends T> codec) {
        this.codec = codec;
    }

    @Nullable
    public abstract T mount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be);
}
