package com.zurrtum.create.api.contraption.storage.fluid;

import com.google.common.collect.ImmutableMap;
import com.zurrtum.create.infrastructure.fluids.CombinedTankWrapper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import net.minecraft.class_2338;

/**
 * Wrapper around many MountedFluidStorages, providing access to all of them as one storage.
 * They can still be accessed individually through the map.
 */
public class MountedFluidStorageWrapper extends CombinedTankWrapper {
    public final ImmutableMap<class_2338, MountedFluidStorage> storages;

    public MountedFluidStorageWrapper(ImmutableMap<class_2338, MountedFluidStorage> storages) {
        super(storages.values().toArray(FluidInventory[]::new));
        this.storages = storages;
    }
}
