package com.zurrtum.create.api.contraption.transformable;

import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.content.contraptions.StructureTransform;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

/**
 * Registry for custom transformations to apply to blocks after they've been moved by a contraption.
 * These interfaces are alternatives to the {@link TransformableBlock} and {@link TransformableBlockEntity} interfaces.
 */
public class MovedBlockTransformerRegistries {
    public static final SimpleRegistry<class_2248, BlockTransformer> BLOCK_TRANSFORMERS = SimpleRegistry.create();
    public static final SimpleRegistry<class_2591<?>, BlockEntityTransformer> BLOCK_ENTITY_TRANSFORMERS = SimpleRegistry.create();

    @FunctionalInterface
    public interface BlockTransformer {
        class_2680 transform(class_2680 state, StructureTransform transform);
    }

    @FunctionalInterface
    public interface BlockEntityTransformer {
        void transform(class_2586 be, StructureTransform transform);
    }

    private MovedBlockTransformerRegistries() {
        throw new AssertionError("This class should not be instantiated");
    }
}
