package com.zurrtum.create.catnip.math;

import com.zurrtum.create.catnip.data.Iterate;
import org.apache.commons.lang3.mutable.MutableObject;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;

public class VoxelShaper {
    private final Map<class_2350, class_265> shapes = new HashMap<>();

    public static VoxelShaper forHorizontal(class_265 shape, class_2350 facing) {
        return forDirectionsWithRotation(shape, facing, class_2350.class_2353.field_11062, new HorizontalRotationValues());
    }

    public static VoxelShaper forHorizontalAxis(class_265 shape, class_2351 along) {
        return forDirectionsWithRotation(shape, axisAsFace(along), Arrays.asList(class_2350.field_11035, class_2350.field_11034), new HorizontalRotationValues());
    }

    public static VoxelShaper forDirectional(class_265 shape, class_2350 facing) {
        return forDirectionsWithRotation(shape, facing, Arrays.asList(Iterate.directions), new DefaultRotationValues());
    }

    public static VoxelShaper forAxis(class_265 shape, class_2351 along) {
        return forDirectionsWithRotation(
            shape,
            axisAsFace(along),
            Arrays.asList(class_2350.field_11035, class_2350.field_11034, class_2350.field_11036),
            new DefaultRotationValues()
        );
    }

    public static class_2350 axisAsFace(class_2351 axis) {
        return class_2350.method_10156(class_2352.field_11056, axis);
    }

    protected static float horizontalAngleFromDirection(class_2350 direction) {
        return (float) ((Math.max(direction.method_10161(), 0) & 3) * 90);
    }

    protected static VoxelShaper forDirectionsWithRotation(
        class_265 shape,
        class_2350 facing,
        Iterable<class_2350> directions,
        Function<class_2350, class_243> rotationValues
    ) {
        VoxelShaper voxelShaper = new VoxelShaper();
        for (class_2350 dir : directions) {
            voxelShaper.shapes.put(dir, rotate(shape, facing, dir, rotationValues));
        }
        return voxelShaper;
    }

    protected static class_265 rotate(class_265 shape, class_2350 from, class_2350 to, Function<class_2350, class_243> usingValues) {
        if (from == to)
            return shape;

        return rotatedCopy(shape, usingValues.apply(from).method_22882().method_1019(usingValues.apply(to)));
    }

    protected static class_265 rotatedCopy(class_265 shape, class_243 rotation) {
        if (rotation.equals(class_243.field_1353))
            return shape;

        MutableObject<class_265> result = new MutableObject<>(class_259.method_1073());
        class_243 center = new class_243(8, 8, 8);

        shape.method_1089((x1, y1, z1, x2, y2, z2) -> {
            class_243 v1 = new class_243(x1, y1, z1).method_1021(16).method_1020(center);
            class_243 v2 = new class_243(x2, y2, z2).method_1021(16).method_1020(center);

            v1 = VecHelper.rotate(v1, (float) rotation.field_1352, class_2351.field_11048);
            v1 = VecHelper.rotate(v1, (float) rotation.field_1351, class_2351.field_11052);
            v1 = VecHelper.rotate(v1, (float) rotation.field_1350, class_2351.field_11051).method_1019(center);

            v2 = VecHelper.rotate(v2, (float) rotation.field_1352, class_2351.field_11048);
            v2 = VecHelper.rotate(v2, (float) rotation.field_1351, class_2351.field_11052);
            v2 = VecHelper.rotate(v2, (float) rotation.field_1350, class_2351.field_11051).method_1019(center);

            class_265 rotated = blockBox(v1, v2);
            result.setValue(class_259.method_1084(result.getValue(), rotated));
        });

        return result.getValue();
    }

    protected static class_265 blockBox(class_243 v1, class_243 v2) {
        return class_2248.method_9541(
            Math.min(v1.field_1352, v2.field_1352),
            Math.min(v1.field_1351, v2.field_1351),
            Math.min(v1.field_1350, v2.field_1350),
            Math.max(v1.field_1352, v2.field_1352),
            Math.max(v1.field_1351, v2.field_1351),
            Math.max(v1.field_1350, v2.field_1350)
        );
    }

    public class_265 get(class_2350 direction) {
        return shapes.get(direction);
    }

    public class_265 get(class_2351 axis) {
        return shapes.get(axisAsFace(axis));
    }

    public VoxelShaper withVerticalShapes(class_265 upShape) {
        shapes.put(class_2350.field_11036, upShape);
        shapes.put(class_2350.field_11033, rotatedCopy(upShape, new class_243(180, 0, 0)));
        return this;
    }

    public VoxelShaper withShape(class_265 shape, class_2350 facing) {
        shapes.put(facing, shape);
        return this;
    }

    protected static class DefaultRotationValues implements Function<class_2350, class_243> {
        // assume facing up as the default rotation
        @Override
        public class_243 apply(class_2350 direction) {
            return new class_243(
                direction == class_2350.field_11036 ? 0 : (class_2350.class_2353.field_11064.method_10182(direction) ? 180 : 90),
                -horizontalAngleFromDirection(direction),
                0
            );
        }
    }

    protected static class HorizontalRotationValues implements Function<class_2350, class_243> {
        @Override
        public class_243 apply(class_2350 direction) {
            return new class_243(0, -horizontalAngleFromDirection(direction), 0);
        }
    }
}
