package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.model.LayerBakedModel;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;

public class PartialElementRenderer extends class_11239<PartialRenderState> {
    private static final Map<PartialRenderState, GpuTexture> TEXTURES = new IdentityHashMap<>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public PartialElementRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(PartialRenderState block) {
        GpuTexture texture = TEXTURES.remove(block);
        if (texture != null) {
            texture.close();
        }
    }

    @Override
    public void render(PartialRenderState partial, class_11246 state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        GpuTexture texture = TEXTURES.get(partial);
        boolean draw = texture == null || partial.dirty;
        if (draw) {
            float size = partial.size * windowScaleFactor;
            if (partial.dirty) {
                partial.clearDirty();
                if (texture != null && texture.width() != size) {
                    texture.close();
                    texture = null;
                }
            }
            if (texture == null) {
                texture = GpuTexture.create((int) size);
                TEXTURES.put(partial, texture);
            }
            RenderSystem.setProjectionMatrix(field_60042.method_71092(size, size), class_10366.field_54954);
            texture.prepare();
            matrices.method_22903();
            if (partial.padding != 0) {
                size -= partial.padding * windowScaleFactor;
            }
            matrices.method_22905(size, size, size);
            partial.transform(matrices);
            class_310 mc = class_310.method_1551();
            class_11515 blockRenderLayer = LayerBakedModel.getBlockRenderLayer(partial.model, () -> class_11515.field_60923);
            class_1921 layer = blockRenderLayer == class_11515.field_60926 ? class_4722.method_29382() : class_4722.method_24074();
            SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
            mc.method_1541().method_3355(
                class_2246.field_10124.method_9564(),
                class_2338.field_10980,
                world,
                matrices,
                field_59933.getBuffer(layer),
                false,
                List.of(partial.model)
            );
            field_59933.method_22993();
            matrices.method_22909();
            texture.clear();
        }
        state.method_71996(new class_11241(
            class_10799.field_59968,
            class_11231.method_70900(texture.textureView()),
            partial.field_60999,
            partial.x1,
            partial.y1,
            partial.x2,
            partial.y2,
            0.0F,
            1.0F,
            1.0F,
            0.0F,
            -1,
            partial.scissor,
            null
        ));
    }

    @Override
    protected void render(PartialRenderState partial, class_4587 matrices) {
    }

    @Override
    protected String method_70906() {
        return "Partial";
    }

    @Override
    public Class<PartialRenderState> method_70903() {
        return PartialRenderState.class;
    }
}
