package com.zurrtum.create.client.catnip.outliner;

import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class ChasingAABBOutline extends AABBOutline {

    class_238 targetBB;
    class_238 prevBB;

    public ChasingAABBOutline(class_238 bb) {
        super(bb);
        prevBB = bb.method_1014(0);
        targetBB = bb.method_1014(0);
    }

    public void target(class_238 target) {
        targetBB = target;
    }

    @Override
    public void tick() {
        prevBB = bb;
        setBounds(interpolateBBs(bb, targetBB, .5f));
    }

    @Override
    public void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, float pt) {
        params.loadColor(colorTemp);
        int lightmap = params.lightmap;
        boolean disableLineNormals = params.disableLineNormals;
        renderBox(ms, buffer, camera, interpolateBBs(prevBB, bb, pt), colorTemp, lightmap, disableLineNormals);
    }

    private static class_238 interpolateBBs(class_238 current, class_238 target, float pt) {
        return new class_238(
            class_3532.method_16436(pt, current.field_1323, target.field_1323),
            class_3532.method_16436(pt, current.field_1322, target.field_1322),
            class_3532.method_16436(pt, current.field_1321, target.field_1321),
            class_3532.method_16436(pt, current.field_1320, target.field_1320),
            class_3532.method_16436(pt, current.field_1325, target.field_1325),
            class_3532.method_16436(pt, current.field_1324, target.field_1324)
        );
    }

}
