package com.zurrtum.create.client.catnip.render;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache.Compartment;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import org.apache.commons.lang3.tuple.Pair;

import java.util.function.Supplier;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_4587;

public class CachedBuffers {

    public static final Compartment<class_2680> GENERIC_BLOCK = new Compartment<>();
    public static final Compartment<PartialModel> PARTIAL = new Compartment<>();
    public static final Compartment<Pair<class_2350, PartialModel>> DIRECTIONAL_PARTIAL = new Compartment<>();

    /**
     * Creates and caches a SuperByteBuffer that has the model of a BlockState baked into it
     *
     * @param toRender the BlockState to be rendered
     * @return the cached SuperByteBuffer
     */
    public static SuperByteBuffer block(class_2680 toRender) {
        return block(GENERIC_BLOCK, toRender);
    }

    /**
     * Creates a SuperByteBuffer that has the model of a BlockState baked into it <br />
     * and caches it in the given Compartment
     *
     * @param compartment the Compartment the Buffer should be cached in
     * @param toRender    the BlockState to be rendered
     * @return the cached SuperByteBuffer
     */
    public static SuperByteBuffer block(Compartment<class_2680> compartment, class_2680 toRender) {
        return SuperByteBufferCache.getInstance().get(compartment, toRender, () -> SuperBufferFactory.getInstance().createForBlock(toRender));
    }

    public static SuperByteBuffer partial(PartialModel partial, class_2680 referenceState) {
        return SuperByteBufferCache.getInstance()
            .get(PARTIAL, partial, () -> SuperBufferFactory.getInstance().createForBlock(partial.get(), referenceState));
    }

    public static SuperByteBuffer partial(PartialModel partial, class_2680 referenceState, Supplier<class_4587> modelTransform) {
        return SuperByteBufferCache.getInstance()
            .get(PARTIAL, partial, () -> SuperBufferFactory.getInstance().createForBlock(partial.get(), referenceState, modelTransform.get()));
    }

    public static SuperByteBuffer partialFacing(PartialModel partial, class_2680 referenceState) {
        class_2350 facing = referenceState.method_11654(class_2741.field_12525);
        return partialFacing(partial, referenceState, facing);
    }

    public static SuperByteBuffer partialFacing(PartialModel partial, class_2680 referenceState, class_2350 facing) {
        return partialDirectional(partial, referenceState, facing, rotateToFace(facing));
    }

    public static SuperByteBuffer partialFacingVertical(PartialModel partial, class_2680 referenceState, class_2350 facing) {
        return partialDirectional(partial, referenceState, facing, rotateToFaceVertical(facing));
    }

    public static SuperByteBuffer partialDirectional(
        PartialModel partial,
        class_2680 referenceState,
        class_2350 dir,
        Supplier<class_4587> modelTransform
    ) {
        return SuperByteBufferCache.getInstance().get(
            DIRECTIONAL_PARTIAL,
            Pair.of(dir, partial),
            () -> SuperBufferFactory.getInstance().createForBlock(partial.get(), referenceState, modelTransform.get())
        );
    }

    public static Supplier<class_4587> rotateToFace(class_2350 facing) {
        return () -> {
            class_4587 stack = new class_4587();
            TransformStack.of(stack).center().rotateYDegrees(AngleHelper.horizontalAngle(facing)).rotateXDegrees(AngleHelper.verticalAngle(facing))
                .uncenter();
            return stack;
        };
    }

    public static Supplier<class_4587> rotateToFaceVertical(class_2350 facing) {
        return () -> {
            class_4587 stack = new class_4587();
            TransformStack.of(stack).center().rotateYDegrees(AngleHelper.horizontalAngle(facing))
                .rotateXDegrees(AngleHelper.verticalAngle(facing) + 90).uncenter();
            return stack;
        };
    }
}
