package com.zurrtum.create.client.catnip.render;

import com.zurrtum.create.client.foundation.render.RenderTypes;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import net.minecraft.class_1088;
import net.minecraft.class_11515;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_750;
import net.minecraft.class_9799;
import net.minecraft.client.render.*;
import java.util.SortedMap;

public class DefaultSuperRenderTypeBuffer implements SuperRenderTypeBuffer {

    private static final DefaultSuperRenderTypeBuffer INSTANCE = new DefaultSuperRenderTypeBuffer();

    public static DefaultSuperRenderTypeBuffer getInstance() {
        return INSTANCE;
    }

    protected SuperRenderTypeBufferPhase earlyBuffer;
    protected SuperRenderTypeBufferPhase defaultBuffer;
    protected SuperRenderTypeBufferPhase lateBuffer;

    public DefaultSuperRenderTypeBuffer() {
        earlyBuffer = new SuperRenderTypeBufferPhase();
        defaultBuffer = new SuperRenderTypeBufferPhase();
        lateBuffer = new SuperRenderTypeBufferPhase();
    }

    @Override
    public class_4588 getEarlyBuffer(class_1921 type) {
        return earlyBuffer.bufferSource.getBuffer(type);
    }

    @Override
    public class_4588 getBuffer(class_1921 type) {
        return defaultBuffer.bufferSource.getBuffer(type);
    }

    @Override
    public class_4588 getLateBuffer(class_1921 type) {
        return lateBuffer.bufferSource.getBuffer(type);
    }

    @Override
    public void draw() {
        earlyBuffer.bufferSource.method_22993();
        defaultBuffer.bufferSource.method_22993();
        lateBuffer.bufferSource.method_22993();
    }

    @Override
    public void draw(class_1921 type) {
        earlyBuffer.bufferSource.method_22994(type);
        defaultBuffer.bufferSource.method_22994(type);
        lateBuffer.bufferSource.method_22994(type);
    }

    public static class SuperRenderTypeBufferPhase {
        // Visible clones from RenderBuffers
        private final class_750 fixedBufferPack = new class_750();
        private final SortedMap<class_1921, class_9799> fixedBuffers = class_156.method_654(
            new Object2ObjectLinkedOpenHashMap<>(), map -> {
                map.put(class_4722.method_24073(), fixedBufferPack.method_3154(class_11515.field_60923));
                map.put(class_4722.method_24074(), fixedBufferPack.method_3154(class_11515.field_60925));
                map.put(class_4722.method_24059(), fixedBufferPack.method_3154(class_11515.field_60924));
                map.put(class_4722.method_29382(), fixedBufferPack.method_3154(class_11515.field_60926));
                put(map, class_4722.method_24067());
                put(map, class_4722.method_24069());
                put(map, class_4722.method_24070());
                put(map, class_4722.method_24071());
                put(map, class_4722.method_45783());
                map.put(class_4722.method_24072(), new class_9799(786432));
                put(map, class_1921.method_27949());
                put(map, class_1921.method_23590());
                put(map, class_1921.method_30676());
                put(map, class_1921.method_23591());
                put(map, class_1921.method_23589());
                class_1088.field_21772.forEach(renderType -> put(map, renderType));

                //extras
                put(map, PonderRenderTypes.outlineSolid());
                put(map, PonderRenderTypes.translucent());
                put(map, PonderRenderTypes.fluid());
                put(map, RenderTypes.translucent());
                put(map, RenderTypes.additive());
            }
        );
        private final class_4598 bufferSource = class_4597.method_22992(fixedBuffers, new class_9799(256));

        private static void put(Object2ObjectLinkedOpenHashMap<class_1921, class_9799> map, class_1921 type) {
            map.put(type, new class_9799(type.method_22722()));
        }

    }
}
