package com.zurrtum.create.client.content.contraptions.actors.psi;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlock;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;

public class PortableStorageInterfaceRenderer extends SafeBlockEntityRenderer<PortableStorageInterfaceBlockEntity> {

    public PortableStorageInterfaceRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(
        PortableStorageInterfaceBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {
        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        class_2680 blockState = be.method_11010();
        float progress = be.getExtensionDistance(partialTicks);
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        render(blockState, be.isConnected(), progress, null, sbb -> sbb.light(light).renderInto(ms, vb));
    }

    public static void renderInContraption(
        MovementContext context,
        VirtualRenderWorld renderWorld,
        ContraptionMatrices matrices,
        class_4597 buffer
    ) {
        class_2680 blockState = context.state;
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();

        LerpedFloat animation = PortableStorageInterfaceMovement.getAnimation(context);
        float progress = animation.getValue(renderPartialTicks);
        boolean lit = animation.settled();
        render(
            blockState,
            lit,
            progress,
            matrices.getModel(),
            sbb -> sbb.light(class_761.method_23794(renderWorld, context.localPos)).useLevelLight(context.world, matrices.getWorld())
                .renderInto(matrices.getViewProjection(), vb)
        );
    }

    private static void render(class_2680 blockState, boolean lit, float progress, class_4587 local, Consumer<SuperByteBuffer> drawCallback) {
        SuperByteBuffer middle = CachedBuffers.partial(getMiddleForState(blockState, lit), blockState);
        SuperByteBuffer top = CachedBuffers.partial(getTopForState(blockState), blockState);

        if (local != null) {
            middle.transform(local);
            top.transform(local);
        }
        class_2350 facing = blockState.method_11654(PortableStorageInterfaceBlock.field_10927);
        rotateToFacing(middle, facing);
        rotateToFacing(top, facing);
        middle.translate(0, progress * 0.5f + 0.375f, 0);
        top.translate(0, progress, 0);

        drawCallback.accept(middle);
        drawCallback.accept(top);
    }

    private static void rotateToFacing(SuperByteBuffer buffer, class_2350 facing) {
        buffer.center().rotateYDegrees(AngleHelper.horizontalAngle(facing))
            .rotateXDegrees(facing == class_2350.field_11036 ? 0 : facing == class_2350.field_11033 ? 180 : 90).uncenter();
    }

    static PortableStorageInterfaceBlockEntity getTargetPSI(MovementContext context) {
        String _workingPos_ = PortableStorageInterfaceMovement._workingPos_;
        if (!context.data.method_10545(_workingPos_))
            return null;

        class_2338 pos = context.data.method_67491(_workingPos_, class_2338.field_25064).orElse(class_2338.field_10980);
        class_2586 blockEntity = context.world.method_8321(pos);
        if (!(blockEntity instanceof PortableStorageInterfaceBlockEntity psi))
            return null;

        if (!psi.isTransferring())
            return null;
        return psi;
    }

    static PartialModel getMiddleForState(class_2680 state, boolean lit) {
        if (state.method_27852(AllBlocks.PORTABLE_FLUID_INTERFACE))
            return lit ? AllPartialModels.PORTABLE_FLUID_INTERFACE_MIDDLE_POWERED : AllPartialModels.PORTABLE_FLUID_INTERFACE_MIDDLE;
        return lit ? AllPartialModels.PORTABLE_STORAGE_INTERFACE_MIDDLE_POWERED : AllPartialModels.PORTABLE_STORAGE_INTERFACE_MIDDLE;
    }

    static PartialModel getTopForState(class_2680 state) {
        if (state.method_27852(AllBlocks.PORTABLE_FLUID_INTERFACE))
            return AllPartialModels.PORTABLE_FLUID_INTERFACE_TOP;
        return AllPartialModels.PORTABLE_STORAGE_INTERFACE_TOP;
    }

}
