package com.zurrtum.create.client.content.contraptions.chassis;

import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.content.contraptions.chassis.ChassisBlockEntity;
import java.util.*;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;

public class ChassisRangeDisplay {

    private static final int DISPLAY_TIME = 200;
    private static GroupEntry lastHoveredGroup = null;

    private static class Entry {
        ChassisBlockEntity be;
        int timer;

        public Entry(ChassisBlockEntity be) {
            this.be = be;
            timer = DISPLAY_TIME;
            Outliner.getInstance().showCluster(getOutlineKey(), createSelection(be)).colored(0xFFFFFF).disableLineNormals().lineWidth(1 / 16f)
                .withFaceTexture(AllSpecialTextures.HIGHLIGHT_CHECKERED);
        }

        protected Object getOutlineKey() {
            return Pair.of(be.method_11016(), 1);
        }

        protected Set<class_2338> createSelection(ChassisBlockEntity chassis) {
            Set<class_2338> positions = new HashSet<>();
            List<class_2338> includedBlockPositions = chassis.getIncludedBlockPositions(null, true);
            if (includedBlockPositions == null)
                return Collections.emptySet();
            positions.addAll(includedBlockPositions);
            return positions;
        }

    }

    private static class GroupEntry extends Entry {

        List<ChassisBlockEntity> includedBEs;

        public GroupEntry(ChassisBlockEntity be) {
            super(be);
        }

        @Override
        protected Object getOutlineKey() {
            return this;
        }

        @Override
        protected Set<class_2338> createSelection(ChassisBlockEntity chassis) {
            Set<class_2338> list = new HashSet<>();
            includedBEs = be.collectChassisGroup();
            if (includedBEs == null)
                return list;
            for (ChassisBlockEntity chassisBlockEntity : includedBEs)
                list.addAll(super.createSelection(chassisBlockEntity));
            return list;
        }

    }

    static Map<class_2338, Entry> entries = new HashMap<>();
    static List<GroupEntry> groupEntries = new ArrayList<>();

    public static void tick(class_310 mc) {
        class_1657 player = mc.field_1724;
        class_1937 world = mc.field_1687;
        boolean hasWrench = player.method_6047().method_31574(AllItems.WRENCH);

        for (Iterator<class_2338> iterator = entries.keySet().iterator(); iterator.hasNext(); ) {
            class_2338 pos = iterator.next();
            Entry entry = entries.get(pos);
            if (tickEntry(world, entry, hasWrench))
                iterator.remove();
            Outliner.getInstance().keep(entry.getOutlineKey());
        }

        for (Iterator<GroupEntry> iterator = groupEntries.iterator(); iterator.hasNext(); ) {
            GroupEntry group = iterator.next();
            if (tickEntry(world, group, hasWrench)) {
                iterator.remove();
                if (group == lastHoveredGroup)
                    lastHoveredGroup = null;
            }
            Outliner.getInstance().keep(group.getOutlineKey());
        }

        if (!hasWrench)
            return;

        class_239 over = mc.field_1765;
        if (!(over instanceof class_3965 ray))
            return;
        class_2338 pos = ray.method_17777();
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null || blockEntity.method_11015())
            return;
        if (!(blockEntity instanceof ChassisBlockEntity chassisBlockEntity))
            return;

        boolean ctrl = class_437.method_25441();

        if (ctrl) {
            GroupEntry existingGroupForPos = getExistingGroupForPos(pos);
            if (existingGroupForPos != null) {
                for (ChassisBlockEntity included : existingGroupForPos.includedBEs)
                    entries.remove(included.method_11016());
                existingGroupForPos.timer = DISPLAY_TIME;
                return;
            }
        }

        if (!entries.containsKey(pos) || ctrl)
            display(chassisBlockEntity);
        else {
            if (!ctrl)
                entries.get(pos).timer = DISPLAY_TIME;
        }
    }

    private static boolean tickEntry(class_1937 world, Entry entry, boolean hasWrench) {
        ChassisBlockEntity chassisBlockEntity = entry.be;
        class_1937 beWorld = chassisBlockEntity.method_10997();

        if (chassisBlockEntity.method_11015() || beWorld == null || beWorld != world || !world.method_8477(chassisBlockEntity.method_11016())) {
            return true;
        }

        if (!hasWrench && entry.timer > 20) {
            entry.timer = 20;
            return false;
        }

        entry.timer--;
        if (entry.timer == 0)
            return true;
        return false;
    }

    public static void display(ChassisBlockEntity chassis) {

        // Display a group and kill any selections of its contained chassis blocks
        if (class_437.method_25441()) {
            GroupEntry hoveredGroup = new GroupEntry(chassis);

            for (ChassisBlockEntity included : hoveredGroup.includedBEs)
                Outliner.getInstance().remove(Pair.of(included.method_11016(), 1));

            groupEntries.forEach(entry -> Outliner.getInstance().remove(entry.getOutlineKey()));
            groupEntries.clear();
            entries.clear();
            groupEntries.add(hoveredGroup);
            return;
        }

        // Display an individual chassis and kill any group selections that contained it
        class_2338 pos = chassis.method_11016();
        GroupEntry entry = getExistingGroupForPos(pos);
        if (entry != null)
            Outliner.getInstance().remove(entry.getOutlineKey());

        groupEntries.clear();
        entries.clear();
        entries.put(pos, new Entry(chassis));

    }

    private static GroupEntry getExistingGroupForPos(class_2338 pos) {
        for (GroupEntry groupEntry : groupEntries)
            for (ChassisBlockEntity chassis : groupEntry.includedBEs)
                if (pos.equals(chassis.method_11016()))
                    return groupEntry;
        return null;
    }

}
