package com.zurrtum.create.client.content.contraptions.chassis;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.chassis.StickerBlock;
import com.zurrtum.create.content.contraptions.chassis.StickerBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class StickerRenderer extends SafeBlockEntityRenderer<StickerBlockEntity> {

    public StickerRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(StickerBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {

        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        class_2680 state = be.method_11010();
        SuperByteBuffer head = CachedBuffers.partial(AllPartialModels.STICKER_HEAD, state);
        float offset = be.piston.getValue(AnimationTickHolder.getPartialTicks(be.method_10997()));

        if (be.method_10997() != class_310.method_1551().field_1687 && !be.isVirtual())
            offset = state.method_11654(StickerBlock.EXTENDED) ? 1 : 0;

        class_2350 facing = state.method_11654(StickerBlock.field_10927);
        head.nudge(be.hashCode()).center().rotateYDegrees(AngleHelper.horizontalAngle(facing)).rotateXDegrees(AngleHelper.verticalAngle(facing) + 90)
            .uncenter().translate(0, (offset * offset) * 4 / 16f, 0);

        head.light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
    }

}
