package com.zurrtum.create.client.content.contraptions.elevator;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.pulley.AbstractPulleyRenderer;
import com.zurrtum.create.client.content.contraptions.pulley.PulleyRenderer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.elevator.ElevatorPulleyBlock;
import com.zurrtum.create.content.contraptions.elevator.ElevatorPulleyBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class ElevatorPulleyRenderer extends KineticBlockEntityRenderer<ElevatorPulleyBlockEntity> {

    public ElevatorPulleyRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(
        ElevatorPulleyBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);

        float offset = PulleyRenderer.getBlockEntityOffset(partialTicks, be);
        boolean running = PulleyRenderer.isPulleyRunning(be);

        SpriteShiftEntry beltShift = AllSpriteShifts.ELEVATOR_BELT;
        SpriteShiftEntry coilShift = AllSpriteShifts.ELEVATOR_COIL;
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        class_1937 world = be.method_10997();
        class_2680 blockState = be.method_11010();
        class_2338 pos = be.method_11016();

        float blockStateAngle = 180 + AngleHelper.horizontalAngle(blockState.method_11654(ElevatorPulleyBlock.HORIZONTAL_FACING));

        SuperByteBuffer magnet = CachedBuffers.partial(AllPartialModels.ELEVATOR_MAGNET, blockState);
        if (running || offset == 0)
            AbstractPulleyRenderer.renderAt(world, magnet.center().rotateYDegrees(blockStateAngle).uncenter(), offset, pos, ms, vb);

        SuperByteBuffer rotatedCoil = getRotatedCoil(be);
        if (offset == 0) {
            rotatedCoil.light(light).renderInto(ms, vb);
            return;
        }

        AbstractPulleyRenderer.scrollCoil(rotatedCoil, coilShift, offset, 2).light(light).renderInto(ms, vb);

        float spriteSize = beltShift.getTarget().method_4575() - beltShift.getTarget().method_4593();

        double beltScroll = (-(offset + .5) - Math.floor(-(offset + .5))) / 2;
        SuperByteBuffer halfRope = CachedBuffers.partial(AllPartialModels.ELEVATOR_BELT_HALF, blockState);
        SuperByteBuffer rope = CachedBuffers.partial(AllPartialModels.ELEVATOR_BELT, blockState);

        float f = offset % 1;
        if (f < .25f || f > .75f) {
            halfRope.center().rotateYDegrees(blockStateAngle).uncenter();
            AbstractPulleyRenderer.renderAt(
                world,
                halfRope.shiftUVScrolling(beltShift, (float) beltScroll * spriteSize),
                f > .75f ? f - 1 : f,
                pos,
                ms,
                vb
            );
        }

        if (!running)
            return;

        for (int i = 0; i < offset - .25f; i++) {
            rope.center().rotateYDegrees(blockStateAngle).uncenter();
            AbstractPulleyRenderer.renderAt(world, rope.shiftUVScrolling(beltShift, (float) beltScroll * spriteSize), offset - i, pos, ms, vb);
        }
    }

    @Override
    protected class_2680 getRenderedBlockState(ElevatorPulleyBlockEntity be) {
        return shaft(getRotationAxisOf(be));
    }

    protected SuperByteBuffer getRotatedCoil(KineticBlockEntity be) {
        class_2680 blockState = be.method_11010();
        return CachedBuffers.partialFacing(AllPartialModels.ELEVATOR_COIL, blockState, blockState.method_11654(ElevatorPulleyBlock.HORIZONTAL_FACING));
    }

    @Override
    public boolean method_3563() {
        return true;
    }

}
