package com.zurrtum.create.client.content.contraptions.pulley;

import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;

public abstract class AbstractPulleyRenderer<T extends KineticBlockEntity> extends KineticBlockEntityRenderer<T> {

    private PartialModel halfRope;
    private PartialModel halfMagnet;

    public AbstractPulleyRenderer(class_5614.class_5615 context, PartialModel halfRope, PartialModel halfMagnet) {
        super(context);
        this.halfRope = halfRope;
        this.halfMagnet = halfMagnet;
    }

    @Override
    public boolean method_3563() {
        return true;
    }

    @Override
    protected void renderSafe(T be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {

        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        float offset = getOffset(be, partialTicks);
        boolean running = isRunning(be);

        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        scrollCoil(getRotatedCoil(be), getCoilShift(), offset, 1).light(light).renderInto(ms, vb);

        class_1937 world = be.method_10997();
        class_2680 blockState = be.method_11010();
        class_2338 pos = be.method_11016();

        SuperByteBuffer halfMagnet = CachedBuffers.partial(this.halfMagnet, blockState);
        SuperByteBuffer halfRope = CachedBuffers.partial(this.halfRope, blockState);
        SuperByteBuffer magnet = renderMagnet(be);
        SuperByteBuffer rope = renderRope(be);

        if (running || offset == 0)
            renderAt(world, offset > .25f ? magnet : halfMagnet, offset, pos, ms, vb);

        float f = offset % 1;
        if (offset > .75f && (f < .25f || f > .75f))
            renderAt(world, halfRope, f > .75f ? f - 1 : f, pos, ms, vb);

        if (!running)
            return;

        for (int i = 0; i < offset - 1.25f; i++)
            renderAt(world, rope, offset - i - 1, pos, ms, vb);
    }

    public static void renderAt(class_1936 world, SuperByteBuffer partial, float offset, class_2338 pulleyPos, class_4587 ms, class_4588 buffer) {
        class_2338 actualPos = pulleyPos.method_10087((int) offset);
        int light = class_761.method_23793(class_761.class_10948.field_58200, world, world.method_8320(actualPos), actualPos);
        partial.translate(0, -offset, 0).light(light).renderInto(ms, buffer);
    }

    protected abstract class_2351 getShaftAxis(T be);

    protected abstract PartialModel getCoil();

    protected abstract SpriteShiftEntry getCoilShift();

    protected abstract SuperByteBuffer renderRope(T be);

    protected abstract SuperByteBuffer renderMagnet(T be);

    protected abstract float getOffset(T be, float partialTicks);

    protected abstract boolean isRunning(T be);

    @Override
    protected class_2680 getRenderedBlockState(T be) {
        return shaft(getShaftAxis(be));
    }

    protected SuperByteBuffer getRotatedCoil(T be) {
        class_2680 blockState = be.method_11010();
        return CachedBuffers.partialFacing(getCoil(), blockState, class_2350.method_10156(class_2352.field_11056, getShaftAxis(be)));
    }

    public static SuperByteBuffer scrollCoil(SuperByteBuffer sbb, SpriteShiftEntry coilShift, float offset, float speedModifier) {
        if (offset == 0)
            return sbb;
        float spriteSize = coilShift.getTarget().method_4575() - coilShift.getTarget().method_4593();
        offset *= speedModifier / 2;
        double coilScroll = -(offset + 3 / 16f) - Math.floor((offset + 3 / 16f) * -2) / 2;
        return sbb.shiftUVScrolling(coilShift, (float) coilScroll * spriteSize);
    }

    @Override
    public int method_33893() {
        return AllConfigs.server().kinetics.maxRopeLength.get();
    }

}
