package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.ShadedBlockSbbBuilder;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption.RenderedBlocks;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.render.BlockEntityRenderHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_10017;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_897;
import net.minecraft.client.render.*;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ContraptionEntityRenderer<C extends AbstractContraptionEntity, S extends ContraptionEntityRenderer.AbstractContraptionState> extends class_897<C, S> {
    public static final SuperByteBufferCache.Compartment<Pair<Contraption, class_11515>> CONTRAPTION = new SuperByteBufferCache.Compartment<>();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    public ContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public static SuperByteBuffer getBuffer(
        Contraption contraption,
        ClientContraption clientContraption,
        VirtualRenderWorld renderWorld,
        class_11515 renderType
    ) {
        return SuperByteBufferCache.getInstance()
            .get(CONTRAPTION, Pair.of(contraption, renderType), () -> buildStructureBuffer(clientContraption, renderWorld, renderType));
    }

    @SuppressWarnings("unchecked")
    public ClientContraption getOrCreateClientContraptionLazy(Contraption contraption) {
        AtomicReference<ClientContraption> clientContraption = (AtomicReference<ClientContraption>) contraption.clientContraption;
        var out = clientContraption.getAcquire();
        if (out == null) {
            // Another thread may hit this block in the same moment.
            // One thread will win and the ContraptionRenderInfo that
            // it generated will become canonical. It's important that
            // we only maintain one RenderInfo instance, specifically
            // for the VirtualRenderWorld inside.
            clientContraption.compareAndExchangeRelease(null, createClientContraption(contraption));

            // Must get again to ensure we have the canonical instance.
            out = clientContraption.getAcquire();
        }
        return out;
    }

    protected ClientContraption createClientContraption(Contraption contraption) {
        return new ClientContraption(contraption);
    }

    @SuppressWarnings("removal")
    private static SuperByteBuffer buildStructureBuffer(ClientContraption clientContraption, VirtualRenderWorld renderWorld, class_11515 layer) {
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 renderer = dispatcher.method_3350();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();

        class_4587 poseStack = objects.poseStack;
        class_5819 random = objects.random;
        RenderedBlocks blocks = clientContraption.getRenderedBlocks();

        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();

        class_778.method_20544();
        for (class_2338 pos : blocks.positions()) {
            class_2680 state = blocks.lookup().apply(pos);
            if (state.method_26217() == class_2464.field_11458) {
                class_1087 model = dispatcher.method_3349(state);
                long randomSeed = state.method_26190(pos);
                random.method_43052(randomSeed);
                if (class_4696.method_23679(state) == layer) {
                    poseStack.method_22903();
                    poseStack.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());
                    List<class_10889> parts = new ObjectArrayList<>();
                    if (WrapperBlockStateModel.unwrapCompat(model) instanceof WrapperBlockStateModel wrapper) {
                        wrapper.addPartsWithInfo(renderWorld, pos, state, random, parts);
                    } else {
                        model.method_68513(random, parts);
                    }
                    renderer.method_3374(renderWorld, parts, state, pos, poseStack, sbbBuilder, true, class_4608.field_21444);
                    poseStack.method_22909();
                }
            }
        }
        class_778.method_20545();

        return sbbBuilder.end();
    }

    @Override
    public boolean shouldRender(C entity, class_4604 frustum, double cameraX, double cameraY, double cameraZ) {
        if (entity.getContraption() == null)
            return false;
        if (!entity.isAliveOrStale())
            return false;
        if (!entity.isReadyForRender())
            return false;

        return super.method_3933(entity, frustum, cameraX, cameraY, cameraZ);
    }

    @Override
    @SuppressWarnings("unchecked")
    public S method_55269() {
        return (S) new AbstractContraptionState();
    }

    @Override
    public void render(S state, class_4587 poseStack, class_4597 buffers, int overlay) {
        if (state.contraption == null) {
            return;
        }

        ClientContraption clientContraption = state.contraption;
        Contraption contraption = clientContraption.getContraption();
        VirtualRenderWorld renderWorld = clientContraption.getRenderLevel();
        ContraptionMatrices matrices = clientContraption.getMatrices();
        matrices.setup((matrixStack, partialTicks) -> transform(state, matrixStack, partialTicks), poseStack, state);

        if (!VisualizationManager.supportsVisualization(state.world)) {
            for (class_11515 renderType : class_11515.values()) {
                SuperByteBuffer sbb = getBuffer(contraption, clientContraption, renderWorld, renderType);
                if (!sbb.isEmpty()) {
                    class_4588 vc = buffers.getBuffer(getRenderLayer(renderType));
                    sbb.transform(matrices.getModel()).useLevelLight(state.world, matrices.getWorld()).renderInto(poseStack, vc);
                }
            }
        }

        var adjustRenderedBlockEntities = clientContraption.getAndAdjustShouldRenderBlockEntities();
        clientContraption.scratchErroredBlockEntities.clear();
        BlockEntityRenderHelper.renderBlockEntities(
            clientContraption.renderedBlockEntityView,
            adjustRenderedBlockEntities,
            clientContraption.scratchErroredBlockEntities,
            renderWorld,
            state.world,
            matrices.getModelViewProjection(),
            matrices.getLight(),
            buffers,
            AnimationTickHolder.getPartialTicks()
        );
        clientContraption.shouldRenderBlockEntities.andNot(clientContraption.scratchErroredBlockEntities);
        renderActors(state.world, renderWorld, contraption, matrices, buffers);

        matrices.clear();
    }

    private class_1921 getRenderLayer(class_11515 layer) {
        return switch (layer) {
            case field_60923 -> class_1921.method_23577();
            case field_60924 -> class_1921.method_23579();
            case field_60925 -> class_1921.method_23581();
            case field_60926 -> PonderRenderTypes.translucent();
            case field_60927 -> class_1921.method_29997();
        };
    }

    public void transform(S state, class_4587 matrixStack, float partialTicks) {
    }

    @Override
    public void updateRenderState(C entity, S state, float tickProgress) {
        state.world = entity.method_37908();
        Contraption contraption = entity.getContraption();
        state.contraption = contraption != null ? getOrCreateClientContraptionLazy(contraption) : null;
        state.lastRenderX = entity.field_6038;
        state.lastRenderY = entity.field_5971;
        state.lastRenderZ = entity.field_5989;
        state.entityX = entity.method_23317();
        state.entityY = entity.method_23318();
        state.entityZ = entity.method_23321();
    }

    private static void renderActors(
        class_1937 level,
        VirtualRenderWorld renderWorld,
        Contraption c,
        ContraptionMatrices matrices,
        class_4597 buffer
    ) {
        class_4587 m = matrices.getModel();

        for (Pair<class_3499.class_3501, MovementContext> actor : c.getActors()) {
            MovementContext context = actor.getRight();
            if (context == null)
                continue;
            if (context.world == null)
                context.world = level;
            class_3499.class_3501 blockInfo = actor.getLeft();

            MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get(blockInfo.comp_1342());
            if (movementBehaviour != null) {
                MovementRenderBehaviour render = movementBehaviour.getAttachRender();
                if (render == null || c.isHiddenInPortal(blockInfo.comp_1341()))
                    continue;
                m.method_22903();
                TransformStack.of(m).translate(blockInfo.comp_1341());
                render.renderInContraption(context, renderWorld, matrices, buffer);
                m.method_22909();
            }
        }
    }

    public static class AbstractContraptionState extends class_10017 {
        public class_1937 world;
        public ClientContraption contraption;
        public double lastRenderX;
        public double lastRenderY;
        public double lastRenderZ;
        public double entityX;
        public double entityY;
        public double entityZ;
    }

    @SuppressWarnings("removal")
    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();
    }
}
