package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5617;

public class ControlledContraptionEntityRenderer extends ContraptionEntityRenderer<ControlledContraptionEntity, ControlledContraptionEntityRenderer.ControlledContraptionState> {
    public ControlledContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public ControlledContraptionState createRenderState() {
        return new ControlledContraptionState();
    }

    @Override
    public void updateRenderState(ControlledContraptionEntity entity, ControlledContraptionState state, float tickProgress) {
        super.updateRenderState(entity, state, tickProgress);
        state.angle = class_3532.field_29847 * (tickProgress == 1.0F ? entity.angle : AngleHelper.angleLerp(
            tickProgress,
            entity.prevAngle,
            entity.angle
        ));
        state.axis = entity.getRotationAxis();
        state.seed = entity.method_5628();
    }

    @Override
    public void transform(ControlledContraptionState state, class_4587 matrixStack, float partialTicks) {
        PoseTransformStack transformStack = TransformStack.of(matrixStack).nudge(state.seed);
        if (state.axis != null) {
            transformStack.center().rotate(state.angle, state.axis).uncenter();
        }
    }

    public static class ControlledContraptionState extends AbstractContraptionState {
        float angle;
        int seed;
        class_2351 axis;
    }
}
