package com.zurrtum.create.client.content.equipment.armor;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.content.equipment.armor.BacktankUtil;
import com.zurrtum.create.content.equipment.armor.DivingHelmetItem;
import org.joml.Matrix3x2fStack;

import java.util.List;
import net.minecraft.class_1292;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3486;
import net.minecraft.class_3544;
import net.minecraft.class_746;

public class RemainingAirOverlay {
    public static void render(class_310 mc, class_332 guiGraphics) {
        class_746 player = mc.field_1724;
        if (player == null)
            return;
        if (player.method_68878())
            return;
        int timeLeft = AllSynchedDatas.VISUAL_BACKTANK_AIR.get(player);
        if (timeLeft == 0) {
            return;
        }
        boolean isAir = !player.method_5777(class_3486.field_15517) || player.method_37908()
            .method_8320(class_2338.method_49637(player.method_23317(), player.method_23320(), player.method_23321())).method_27852(class_2246.field_10422);
        boolean canBreathe = class_1292.method_5574(player) || player.method_31549().field_7480;
        if ((isAir || canBreathe) && !player.method_5771())
            return;

        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.pushMatrix();

        class_1799 backtank = getDisplayedBacktank(player);
        poseStack.translate(
            guiGraphics.method_51421() / 2 + 90,
            guiGraphics.method_51443() - 53 + (backtank.method_58407(mc.field_1687.method_48963().method_48817()) ? 0 : 9)
        );

        class_2561 text = class_2561.method_43470(class_3544.method_15439(Math.max(0, timeLeft - 1) * 20, mc.field_1687.method_54719().method_54748()));
        guiGraphics.method_51427(backtank, 0, 0);
        int color = 0xFF_FFFFFF;
        if (timeLeft < 60 && timeLeft % 2 == 0) {
            color = Color.mixColors(0xFF_FF0000, color, Math.max(timeLeft / 60f, .25f));
        }
        guiGraphics.method_51439(mc.field_1772, text, 16, 5, color, true);

        poseStack.popMatrix();
    }

    public static class_1799 getDisplayedBacktank(class_746 player) {
        List<class_1799> backtanks = BacktankUtil.getAllWithAir(player);
        if (!backtanks.isEmpty()) {
            return backtanks.getFirst();
        }
        return AllItems.COPPER_BACKTANK.method_7854();
    }

    private static void resetAirData(class_1657 player) {
        int old = AllSynchedDatas.VISUAL_BACKTANK_AIR.get(player);
        if (old == 0) {
            return;
        }
        AllSynchedDatas.VISUAL_BACKTANK_AIR.set(player, 0);
    }

    public static void update(class_746 player, class_1937 world) {
        if (player.method_31549().field_7480) {
            resetAirData(player);
            return;
        }
        boolean lavaDiving = player.method_5771();
        if (!lavaDiving && (!player.method_5777(class_3486.field_15517) || world.method_8320(class_2338.method_49637(
            player.method_23317(),
            player.method_23320(),
            player.method_23321()
        )).method_27852(class_2246.field_10422) || player.method_6094() || class_1292.method_5574(player))) {
            resetAirData(player);
            return;
        }

        class_1799 helmet = DivingHelmetItem.getWornItem(player);
        if (helmet.method_7960()) {
            resetAirData(player);
            return;
        }

        if (lavaDiving && helmet.method_58407(world.method_48963().method_48817())) {
            resetAirData(player);
            return;
        }

        List<class_1799> backtanks = BacktankUtil.getAllWithAir(player);
        if (backtanks.isEmpty() || (lavaDiving && backtanks.stream()
            .allMatch(backtank -> backtank.method_58407(world.method_48963().method_48817())))) {
            resetAirData(player);
            return;
        }

        int visualBacktankAir = 0;
        for (class_1799 stack : backtanks)
            visualBacktankAir += BacktankUtil.getAir(stack);

        if (AllSynchedDatas.VISUAL_BACKTANK_AIR.get(player) == visualBacktankAir) {
            return;
        }
        AllSynchedDatas.VISUAL_BACKTANK_AIR.set(player, visualBacktankAir);
    }
}
