package com.zurrtum.create.client.content.equipment.blueprint;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import net.minecraft.class_10017;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5617;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_918;
import org.joml.Matrix3f;

public class BlueprintRenderer extends class_897<BlueprintEntity, BlueprintRenderer.BlueprintState> {
    public BlueprintRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    @SuppressWarnings("unchecked")
    public void updateRenderState(BlueprintEntity entity, BlueprintState state, float tickProgress) {
        state.yaw = entity.method_61415(tickProgress);
        state.world = entity.method_37908();
        state.pitch = entity.method_36455();
        int size = entity.size;
        Couple<class_1799>[] sections = new Couple[size * size];
        for (int x = 0; x < size; x++) {
            for (int y = 0; y < size; y++) {
                int index = x * size + y;
                sections[index] = entity.getSection(index).getDisplayItems();
            }
        }
        state.size = size;
        state.sections = sections;
    }

    @Override
    public void render(BlueprintState state, class_4587 ms, class_4597 buffer, int light) {
        PartialModel partialModel = state.size == 3 ? AllPartialModels.CRAFTING_BLUEPRINT_3x3 : state.size == 2 ? AllPartialModels.CRAFTING_BLUEPRINT_2x2 : AllPartialModels.CRAFTING_BLUEPRINT_1x1;
        SuperByteBuffer sbb = CachedBuffers.partial(partialModel, class_2246.field_10124.method_9564());
        sbb.rotateYDegrees(-state.yaw).rotateXDegrees(90.0F + state.pitch).translate(-.5, -1 / 32f, -.5);
        if (state.size == 2)
            sbb.translate(.5, 0, -.5);

        sbb.disableDiffuse().light(light).renderInto(ms, buffer.getBuffer(class_4722.method_24073()));

        ms.method_22903();

        float fakeNormalXRotation = -15;
        int bl = light >> 4 & 0xf;
        int sl = light >> 20 & 0xf;
        boolean vertical = state.pitch != 0;
        if (state.pitch == -90)
            fakeNormalXRotation = -45;
        else if (state.pitch == 90 || state.yaw % 180 != 0) {
            bl /= 1.35;
            sl /= 1.35;
        }
        int itemLight = class_3532.method_15357(sl + .5) << 20 | (class_3532.method_15357(bl + .5) & 0xf) << 4;

        TransformStack.of(ms).rotateYDegrees(vertical ? 0 : -state.yaw).rotateXDegrees(fakeNormalXRotation);
        Matrix3f copy = new Matrix3f(ms.method_23760().method_23762());

        ms.method_22909();
        ms.method_22903();

        TransformStack.of(ms).rotateYDegrees(-state.yaw).rotateXDegrees(state.pitch).translate(0, 0, 1 / 32f + .001);

        if (state.size == 3)
            ms.method_46416(-1, -1, 0);

        class_4587 squashedMS = new class_4587();
        squashedMS.method_23760().method_23761().mul(ms.method_23760().method_23761());

        class_918 itemRenderer = class_310.method_1551().method_1480();
        for (int x = 0; x < state.size; x++) {
            squashedMS.method_22903();
            for (int y = 0; y < state.size; y++) {
                squashedMS.method_22903();
                squashedMS.method_22905(.5f, .5f, 1 / 1024f);
                state.sections[x * state.size + y].forEachWithContext((stack, primary) -> {
                    if (stack.method_7960())
                        return;

                    squashedMS.method_22903();
                    if (!primary) {
                        squashedMS.method_46416(0.325f, -0.325f, 1);
                        squashedMS.method_22905(.625f, .625f, 1);
                    }

                    squashedMS.method_23760().method_23762().set(copy);

                    itemRenderer.method_23178(stack, class_811.field_4317, itemLight, class_4608.field_21444, squashedMS, buffer, state.world, 0);
                    squashedMS.method_22909();
                });
                squashedMS.method_22909();
                squashedMS.method_46416(1, 0, 0);
            }
            squashedMS.method_22909();
            squashedMS.method_46416(0, 1, 0);
        }

        ms.method_22909();
    }

    @Override
    public BlueprintState method_55269() {
        return new BlueprintState();
    }

    public static class BlueprintState extends class_10017 {
        public int size;
        public float yaw;
        public class_1937 world;
        public float pitch;
        public Couple<class_1799>[] sections;
    }
}
