package com.zurrtum.create.client.content.equipment.potatoCannon;

import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileRenderMode;
import com.zurrtum.create.client.AllPotatoProjectileTransforms;
import com.zurrtum.create.content.equipment.potatoCannon.PotatoProjectileEntity;
import net.minecraft.class_10017;
import net.minecraft.class_10444;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_811;
import net.minecraft.class_897;

public class PotatoProjectileRenderer extends class_897<PotatoProjectileEntity, PotatoProjectileRenderer.PotatoProjectileState> {

    public PotatoProjectileRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public PotatoProjectileState method_55269() {
        return new PotatoProjectileState();
    }

    @Override
    public void updateRenderState(PotatoProjectileEntity entity, PotatoProjectileState state, float tickProgress) {
        super.method_62354(entity, state, tickProgress);
        class_1799 stack = entity.getItem();
        class_310 mc = class_310.method_1551();
        mc.method_65386().method_65598(state.item, stack, class_811.field_4318, entity.method_37908(), null, 0);
        if (stack.method_7960()) {
            return;
        }
        state.box = entity.method_5829();
        state.velocity = entity.method_18798();
        state.translateY = (float) (state.box.method_17940() / 2 - 1 / 8f);
        state.mode = entity.getRenderMode();
        state.transformer = AllPotatoProjectileTransforms.get(state.mode);
        state.camera = mc.method_1560();
        state.pt = tickProgress;
        state.hash = System.identityHashCode(entity) * 31;
    }

    @Override
    public void render(PotatoProjectileState state, class_4587 ms, class_4597 buffer, int light) {
        if (state.item.method_65606())
            return;
        ms.method_22903();
        ms.method_46416(0, state.translateY, 0);
        if (state.transformer != null) {
            state.transformer.transform(state.mode, ms, state);
        }

        state.item.method_65604(ms, buffer, light, class_4608.field_21444);
        ms.method_22909();
    }

    public static class PotatoProjectileState extends class_10017 {
        public class_10444 item = new class_10444();
        public float translateY;
        public PotatoProjectileRenderMode mode;
        public PotatoProjectileTransform<PotatoProjectileRenderMode> transformer;
        public float pt;
        public class_238 box;
        public class_1297 camera;
        public class_243 velocity;
        public int hash;
    }
}
