package com.zurrtum.create.client.content.fluids.drain;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.fluids.drain.ItemDrainBlockEntity;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour.TankSegment;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.util.math.*;

import java.util.Random;

public class ItemDrainRenderer extends SmartBlockEntityRenderer<ItemDrainBlockEntity> {

    public ItemDrainRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(ItemDrainBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        renderFluid(be, partialTicks, ms, buffer, light);
        renderItem(be, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderItem(ItemDrainBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        TransportedItemStack transported = be.heldItem;
        if (transported == null)
            return;

        var msr = TransformStack.of(ms);
        class_243 itemPosition = VecHelper.getCenterOf(be.method_11016());

        class_2350 insertedFrom = transported.insertedFrom;
        if (!insertedFrom.method_10166().method_10179())
            return;

        ms.method_22903();
        ms.method_46416(.5f, 15 / 16f, .5f);
        msr.nudge(0);
        float offset = class_3532.method_16439(partialTicks, transported.prevBeltPosition, transported.beltPosition);
        float sideOffset = class_3532.method_16439(partialTicks, transported.prevSideOffset, transported.sideOffset);

        class_243 offsetVec = class_243.method_24954(insertedFrom.method_10153().method_62675()).method_1021(.5f - offset);
        ms.method_22904(offsetVec.field_1352, offsetVec.field_1351, offsetVec.field_1350);
        boolean alongX = insertedFrom.method_10170().method_10166() == class_2350.class_2351.field_11048;
        if (!alongX)
            sideOffset *= -1;
        ms.method_46416(alongX ? sideOffset : 0, 0, alongX ? 0 : sideOffset);

        class_1799 itemStack = transported.stack;
        Random r = new Random(0);
        class_310 mc = class_310.method_1551();
        class_918 itemRenderer = mc.method_1480();
        int count = class_3532.method_15351(itemStack.method_7947()) / 2;
        boolean renderUpright = BeltHelper.isItemUpright(itemStack);
        itemRenderer.field_55296.method_65598(itemRenderer.field_55297, itemStack, class_811.field_4319, null, null, 0);
        boolean blockItem = itemRenderer.field_55297.method_65608();

        if (renderUpright)
            ms.method_22904(0, 3 / 32d, 0);

        int positive = insertedFrom.method_10171().method_10181();
        float verticalAngle = positive * offset * 360;
        if (insertedFrom.method_10166() != class_2350.class_2351.field_11048)
            msr.rotateXDegrees(verticalAngle);
        if (insertedFrom.method_10166() != class_2350.class_2351.field_11051)
            msr.rotateZDegrees(-verticalAngle);

        if (renderUpright) {
            class_1297 renderViewEntity = mc.field_1719;
            if (renderViewEntity != null) {
                class_243 positionVec = renderViewEntity.method_19538();
                class_243 vectorForOffset = itemPosition.method_1019(offsetVec);
                class_243 diff = vectorForOffset.method_1020(positionVec);

                if (insertedFrom.method_10166() != class_2350.class_2351.field_11048)
                    diff = VecHelper.rotate(diff, verticalAngle, class_2350.class_2351.field_11048);
                if (insertedFrom.method_10166() != class_2350.class_2351.field_11051)
                    diff = VecHelper.rotate(diff, -verticalAngle, class_2350.class_2351.field_11051);

                float yRot = (float) class_3532.method_15349(diff.field_1350, -diff.field_1352);
                ms.method_22907(class_7833.field_40716.rotation((float) (yRot - Math.PI / 2)));
            }
            ms.method_46416(0, 0, -1 / 16f);
        }

        for (int i = 0; i <= count; i++) {
            ms.method_22903();
            if (blockItem)
                ms.method_46416(r.nextFloat() * .0625f * i, 0, r.nextFloat() * .0625f * i);
            ms.method_22905(.5f, .5f, .5f);
            if (!blockItem && !renderUpright)
                msr.rotateXDegrees(90);
            itemRenderer.field_55297.method_65604(ms, buffer, light, overlay);
            ms.method_22909();

            if (!renderUpright) {
                if (!blockItem)
                    msr.rotateYDegrees(10);
                ms.method_22904(0, blockItem ? 1 / 64d : 1 / 16d, 0);
            } else
                ms.method_46416(0, 0, -1 / 16f);
        }

        ms.method_22909();
    }

    protected void renderFluid(ItemDrainBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light) {
        SmartFluidTankBehaviour tank = be.internalTank;
        if (tank == null)
            return;

        TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);

        if (!fluidStack.isEmpty() && level != 0) {
            float yMin = 5f / 16f;
            float min = 2f / 16f;
            float max = min + (12 / 16f);
            float yOffset = (7 / 16f) * level;
            ms.method_22903();
            ms.method_46416(0, yOffset, 0);
            FluidRenderHelper.renderFluidBox(fluidStack, min, yMin - yOffset, min, max, yMin, max, buffer, ms, light, false, false);
            ms.method_22909();
        }

        class_1799 heldItemStack = be.getHeldItemStack();
        if (heldItemStack.method_7960())
            return;
        FluidStack fluidStack2 = GenericItemEmptying.emptyItem(be.method_10997(), heldItemStack, true).getFirst();
        if (fluidStack2.isEmpty()) {
            if (fluidStack.isEmpty())
                return;
            fluidStack2 = fluidStack;
        }

        int processingTicks = be.processingTicks;
        float processingPT = be.processingTicks - partialTicks;
        float processingProgress = 1 - (processingPT - 5) / 10;
        processingProgress = class_3532.method_15363(processingProgress, 0, 1);
        float radius = 0;

        if (processingTicks != -1) {
            radius = (float) (Math.pow(((2 * processingProgress) - 1), 2) - 1);
            class_238 bb = new class_238(0.5, 1.0, 0.5, 0.5, 0.25, 0.5).method_1014(radius / 32f);
            FluidRenderHelper.renderFluidBox(
                fluidStack2,
                (float) bb.field_1323,
                (float) bb.field_1322,
                (float) bb.field_1321,
                (float) bb.field_1320,
                (float) bb.field_1325,
                (float) bb.field_1324,
                buffer,
                ms,
                light,
                true,
                false
            );
        }

    }

}
