package com.zurrtum.create.client.content.kinetics.gauge;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.ShaftRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlock;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlock.Type;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class GaugeRenderer extends ShaftRenderer<GaugeBlockEntity> {

    protected Type type;

    public static GaugeRenderer speed(class_5614.class_5615 context) {
        return new GaugeRenderer(context, Type.SPEED);
    }

    public static GaugeRenderer stress(class_5614.class_5615 context) {
        return new GaugeRenderer(context, Type.STRESS);
    }

    protected GaugeRenderer(class_5614.class_5615 context, Type type) {
        super(context);
        this.type = type;
    }

    @Override
    protected void renderSafe(GaugeBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);

        class_2680 gaugeState = be.method_11010();

        PartialModel partialModel = (type == Type.SPEED ? AllPartialModels.GAUGE_HEAD_SPEED : AllPartialModels.GAUGE_HEAD_STRESS);
        SuperByteBuffer headBuffer = CachedBuffers.partial(partialModel, gaugeState);
        SuperByteBuffer dialBuffer = CachedBuffers.partial(AllPartialModels.GAUGE_DIAL, gaugeState);

        float dialPivot = 5.75f / 16;
        float progress = class_3532.method_16439(partialTicks, be.prevDialState, be.dialState);

        for (class_2350 facing : Iterate.directions) {
            if (!((GaugeBlock) gaugeState.method_26204()).shouldRenderHeadOnFace(be.method_10997(), be.method_11016(), gaugeState, facing))
                continue;

            class_4588 vb = buffer.getBuffer(class_1921.method_23577());
            rotateBufferTowards(dialBuffer, facing).translate(0, dialPivot, dialPivot).rotate((float) (Math.PI / 2 * -progress), class_2350.field_11034)
                .translate(0, -dialPivot, -dialPivot).light(light).renderInto(ms, vb);
            rotateBufferTowards(headBuffer, facing).light(light).renderInto(ms, vb);
        }
    }

    protected SuperByteBuffer rotateBufferTowards(SuperByteBuffer buffer, class_2350 target) {
        return buffer.rotateCentered((float) ((-target.method_10144() - 90) / 180 * Math.PI), class_2350.field_11036);
    }

}
