package com.zurrtum.create.client.content.kinetics.gearbox;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.gearbox.GearboxBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2741;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class GearboxRenderer extends KineticBlockEntityRenderer<GearboxBlockEntity> {

    public GearboxRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(GearboxBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        final class_2351 boxAxis = be.method_11010().method_11654(class_2741.field_12496);
        final class_2338 pos = be.method_11016();
        float time = AnimationTickHolder.getRenderTime(be.method_10997());

        for (class_2350 direction : Iterate.directions) {
            final class_2351 axis = direction.method_10166();
            if (boxAxis == axis)
                continue;

            SuperByteBuffer shaft = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, be.method_11010(), direction);
            float offset = getRotationOffsetForPosition(be, pos, axis);
            float angle = (time * be.getSpeed() * 3f / 10) % 360;

            if (be.getSpeed() != 0 && be.hasSource()) {
                class_2338 source = be.source.method_10059(be.method_11016());
                class_2350 sourceFacing = class_2350.method_10147(source.method_10263(), source.method_10264(), source.method_10260());
                if (sourceFacing.method_10166() == direction.method_10166())
                    angle *= sourceFacing == direction ? 1 : -1;
                else if (sourceFacing.method_10171() == direction.method_10171())
                    angle *= -1;
            }

            angle += offset;
            angle = angle / 180f * (float) Math.PI;

            kineticRotationTransform(shaft, be, axis, angle, light);
            shaft.renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
        }
    }

}
