package com.zurrtum.create.client.content.kinetics.gearbox;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.AbstractInstance;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.kinetics.gearbox.GearboxBlockEntity;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2741;

public class GearboxVisual extends KineticBlockEntityVisual<GearboxBlockEntity> {

    protected final EnumMap<class_2350, RotatingInstance> keys = new EnumMap<>(class_2350.class);
    protected class_2350 sourceFacing;

    public GearboxVisual(VisualizationContext context, GearboxBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);

        final class_2350.class_2351 boxAxis = blockState.method_11654(class_2741.field_12496);

        updateSourceFacing();

        var instancer = instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.SHAFT_HALF));

        for (class_2350 direction : Iterate.directions) {
            final class_2350.class_2351 axis = direction.method_10166();
            if (boxAxis == axis) {
                continue;
            }

            RotatingInstance instance = instancer.createInstance();

            instance.setup(blockEntity, axis, getSpeed(direction)).setPosition(getVisualPosition()).rotateToFace(class_2350.field_11035, direction)
                .setChanged();

            keys.put(direction, instance);
        }
    }

    private float getSpeed(class_2350 direction) {
        float speed = blockEntity.getSpeed();

        if (speed != 0 && sourceFacing != null) {
            if (sourceFacing.method_10166() == direction.method_10166())
                speed *= sourceFacing == direction ? 1 : -1;
            else if (sourceFacing.method_10171() == direction.method_10171())
                speed *= -1;
        }
        return speed;
    }

    protected void updateSourceFacing() {
        if (blockEntity.hasSource()) {
            class_2338 source = blockEntity.source.method_10059(pos);
            sourceFacing = class_2350.method_10147(source.method_10263(), source.method_10264(), source.method_10260());
        } else {
            sourceFacing = null;
        }
    }

    @Override
    public void update(float pt) {
        updateSourceFacing();
        for (Map.Entry<class_2350, RotatingInstance> key : keys.entrySet()) {
            class_2350 direction = key.getKey();
            class_2350.class_2351 axis = direction.method_10166();

            key.getValue().setup(blockEntity, axis, getSpeed(direction)).setChanged();
        }
    }

    @Override
    public void updateLight(float partialTick) {
        relight(keys.values().toArray(FlatLit[]::new));
    }

    @Override
    protected void _delete() {
        keys.values().forEach(AbstractInstance::delete);
        keys.clear();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        keys.values().forEach(consumer);
    }
}
