package com.zurrtum.create.client.content.kinetics.mechanicalArm;

import com.google.common.collect.Lists;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.kinetics.base.SingleAxisRotatingVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.AbstractInstance;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_10444;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class ArmVisual extends SingleAxisRotatingVisual<ArmBlockEntity> implements SimpleDynamicVisual {

    final TransformedInstance base;
    final TransformedInstance lowerBody;
    final TransformedInstance upperBody;
    final TransformedInstance claw;

    private final ArrayList<TransformedInstance> clawGrips;
    private final ArrayList<TransformedInstance> models;
    private final boolean ceiling;

    private final class_4587 poseStack = new class_4587();
    private final class_10444 itemRenderState = new class_10444();

    private boolean wasDancing = false;
    private float baseAngle = Float.NaN;
    private float lowerArmAngle = Float.NaN;
    private float upperArmAngle = Float.NaN;
    private float headAngle = Float.NaN;

    public ArmVisual(VisualizationContext context, ArmBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, Models.partial(AllPartialModels.ARM_COG));

        base = instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ARM_BASE)).createInstance();
        lowerBody = instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ARM_LOWER_BODY)).createInstance();
        upperBody = instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ARM_UPPER_BODY)).createInstance();
        claw = instancerProvider().instancer(
            InstanceTypes.TRANSFORMED,
            Models.partial(blockEntity.goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE)
        ).createInstance();

        TransformedInstance clawGrip1 = instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ARM_CLAW_GRIP_UPPER))
            .createInstance();
        TransformedInstance clawGrip2 = instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ARM_CLAW_GRIP_LOWER))
            .createInstance();

        clawGrips = Lists.newArrayList(clawGrip1, clawGrip2);
        models = Lists.newArrayList(base, lowerBody, upperBody, claw, clawGrip1, clawGrip2);
        ceiling = blockState.method_11654(ArmBlock.CEILING);

        var msr = TransformStack.of(poseStack);
        msr.translate(getVisualPosition());
        msr.center();

        if (ceiling)
            msr.rotateXDegrees(180);

        animate(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        animate(ctx.partialTick());
    }

    private void animate(float pt) {
        if (blockEntity.phase == ArmBlockEntity.Phase.DANCING && blockEntity.getSpeed() != 0) {
            animateRave(pt);
            wasDancing = true;
            return;
        }

        float baseAngleNow = blockEntity.baseAngle.getValue(pt);
        float lowerArmAngleNow = blockEntity.lowerArmAngle.getValue(pt);
        float upperArmAngleNow = blockEntity.upperArmAngle.getValue(pt);
        float headAngleNow = blockEntity.headAngle.getValue(pt);

        boolean settled = class_3532.method_15347(baseAngle, baseAngleNow) && class_3532.method_15347(
            lowerArmAngle,
            lowerArmAngleNow
        ) && class_3532.method_15347(upperArmAngle, upperArmAngleNow) && class_3532.method_15347(
            headAngle,
            headAngleNow
        );

        this.baseAngle = baseAngleNow;
        this.lowerArmAngle = lowerArmAngleNow;
        this.upperArmAngle = upperArmAngleNow;
        this.headAngle = headAngleNow;

        // Need to reset the animation if the arm is dancing. We'd very likely be settled
        if (!settled || wasDancing)
            animateArm();

        wasDancing = false;
    }

    private void animateRave(float partialTick) {
        var ticks = AnimationTickHolder.getTicks(blockEntity.method_10997());
        float renderTick = ticks + partialTick + (blockEntity.hashCode() % 64);

        float baseAngle = (renderTick * 10) % 360;
        float lowerArmAngle = class_3532.method_48781((class_3532.method_15374(renderTick / 4) + 1) / 2, -45, 15);
        float upperArmAngle = class_3532.method_48781((class_3532.method_15374(renderTick / 8) + 1) / 4, -45, 95);
        float headAngle = -lowerArmAngle;
        int color = Color.rainbowColor(ticks * 100).getRGB();
        updateAngles(baseAngle, lowerArmAngle, upperArmAngle, headAngle, color);
    }

    private void animateArm() {
        updateAngles(this.baseAngle, this.lowerArmAngle - 135, this.upperArmAngle - 90, this.headAngle, 0xFFFFFF);
    }

    private void updateAngles(float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle, int color) {
        poseStack.method_22903();

        var msr = TransformStack.of(poseStack);

        ArmRenderer.transformBase(msr, baseAngle);
        base.setTransform(poseStack).setChanged();

        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        lowerBody.setTransform(poseStack).colorRgb(color).setChanged();

        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        upperBody.setTransform(poseStack).colorRgb(color).setChanged();

        ArmRenderer.transformHead(msr, headAngle);

        if (ceiling && blockEntity.goggles)
            msr.rotateZDegrees(180);

        claw.setTransform(poseStack).setChanged();

        if (ceiling && blockEntity.goggles)
            msr.rotateZDegrees(180);

        class_1799 item = blockEntity.heldItem;
        class_310 mc = class_310.method_1551();
        class_918 itemRenderer = mc.method_1480();
        boolean hasItem = !item.method_7960();
        boolean isBlockItem;
        if (hasItem && item.method_7909() instanceof class_1747) {
            itemRenderer.field_55296.method_65598(itemRenderState, item, class_811.field_4319, mc.field_1687, null, 0);
            isBlockItem = itemRenderState.method_65608();
        } else {
            isBlockItem = false;
        }

        for (int index : Iterate.zeroAndOne) {
            poseStack.method_22903();
            int flip = index * 2 - 1;
            ArmRenderer.transformClawHalf(msr, hasItem, isBlockItem, flip);
            clawGrips.get(index).setTransform(poseStack).setChanged();
            poseStack.method_22909();
        }

        poseStack.method_22909();
    }

    @Override
    public void update(float pt) {
        super.update(pt);
        instancerProvider().instancer(
            InstanceTypes.TRANSFORMED,
            Models.partial(blockEntity.goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE)
        ).stealInstance(claw);
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);

        relight(models.toArray(FlatLit[]::new));
    }

    @Override
    protected void _delete() {
        super._delete();
        models.forEach(AbstractInstance::delete);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        models.forEach(consumer);
    }
}
