package com.zurrtum.create.client.content.kinetics.saw;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstancerProvider;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import java.util.function.Consumer;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_2741;

public class SawVisual extends KineticBlockEntityVisual<SawBlockEntity> {

    protected final RotatingInstance rotatingModel;

    public SawVisual(VisualizationContext context, SawBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        rotatingModel = shaft(instancerProvider(), blockState).setup(blockEntity).setPosition(getVisualPosition());
        rotatingModel.setChanged();
    }

    public static RotatingInstance shaft(InstancerProvider instancerProvider, class_2680 state) {
        var facing = state.method_11654(class_2741.field_12525);
        var axis = facing.method_10166();
        // We could change this to return either an Oriented- or SingleAxisRotatingVisual
        if (axis.method_10179()) {
            class_2350 align = facing.method_10153();
            return instancerProvider.instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.SHAFT_HALF)).createInstance()
                .rotateTo(0, 0, 1, align.method_10148(), align.method_10164(), align.method_10165());
        } else {
            return instancerProvider.instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.SHAFT)).createInstance()
                .rotateToFace(state.method_11654(SawBlock.AXIS_ALONG_FIRST_COORDINATE) ? class_2351.field_11048 : class_2351.field_11051);
        }
    }

    @Override
    public void update(float pt) {
        rotatingModel.setup(blockEntity).setChanged();
    }

    @Override
    public void updateLight(float partialTick) {
        relight(rotatingModel);
    }

    @Override
    protected void _delete() {
        rotatingModel.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(rotatingModel);
    }
}
