package com.zurrtum.create.client.content.kinetics.simpleRelays;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class BracketedKineticBlockEntityRenderer extends KineticBlockEntityRenderer<BracketedKineticBlockEntity> {

    public BracketedKineticBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(
        BracketedKineticBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {

        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        if (!be.method_11010().method_27852(AllBlocks.LARGE_COGWHEEL)) {
            super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
            return;
        }

        // Large cogs sometimes have to offset their teeth by 11.25 degrees in order to
        // mesh properly

        class_4588 vc = buffer.getBuffer(class_1921.method_23577());
        class_2351 axis = getRotationAxisOf(be);
        class_2350 facing = class_2350.method_10169(axis, class_2352.field_11056);
        renderRotatingBuffer(
            be,
            CachedBuffers.partialFacingVertical(AllPartialModels.SHAFTLESS_LARGE_COGWHEEL, be.method_11010(), facing),
            ms,
            vc,
            light
        );

        float angle = getAngleForLargeCogShaft(be, axis);
        SuperByteBuffer shaft = CachedBuffers.partialFacingVertical(AllPartialModels.COGWHEEL_SHAFT, be.method_11010(), facing);
        kineticRotationTransform(shaft, be, axis, angle, light);
        shaft.renderInto(ms, vc);

    }

    public static float getAngleForLargeCogShaft(SimpleKineticBlockEntity be, class_2351 axis) {
        class_2338 pos = be.method_11016();
        float offset = getShaftAngleOffset(axis, pos);
        float time = AnimationTickHolder.getRenderTime(be.method_10997());
        return ((time * be.getSpeed() * 3f / 10 + offset) % 360) / 180 * (float) Math.PI;
    }

    public static float getShaftAngleOffset(class_2351 axis, class_2338 pos) {
        if (KineticBlockEntityVisual.shouldOffset(axis, pos)) {
            return 22.5f;
        } else {
            return 0;
        }
    }

}
