package com.zurrtum.create.client.content.kinetics.steamEngine;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class SteamEngineRenderer extends SafeBlockEntityRenderer<SteamEngineBlockEntity> {

    public SteamEngineRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(SteamEngineBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        Float angle = getTargetAngle(be);
        if (angle == null)
            return;

        class_2680 blockState = be.method_11010();
        class_2350 facing = SteamEngineBlock.getFacing(blockState);
        class_2351 facingAxis = facing.method_10166();
        class_2351 axis = class_2351.field_11052;

        PoweredShaftBlockEntity shaft = be.getShaft();
        if (shaft != null)
            axis = KineticBlockEntityRenderer.getRotationAxisOf(shaft);

        boolean roll90 = facingAxis.method_10179() && axis == class_2351.field_11052 || facingAxis.method_10178() && axis == class_2351.field_11051;
        float piston = ((6 / 16f) * class_3532.method_15374(angle) - class_3532.method_15355(class_3532.method_27285(14 / 16f) - class_3532.method_27285(6 / 16f) * class_3532.method_27285(
            class_3532.method_15362(angle))));
        float distance = class_3532.method_15355(class_3532.method_27285(piston - 6 / 16f * class_3532.method_15374(angle)));
        float angle2 = (float) Math.acos(distance / (14 / 16f)) * (class_3532.method_15362(angle) >= 0 ? 1f : -1f);

        class_4588 vb = buffer.getBuffer(class_1921.method_23577());

        transformed(AllPartialModels.ENGINE_PISTON, blockState, facing, roll90).translate(0, piston + 20 / 16f, 0).light(light).renderInto(ms, vb);

        transformed(AllPartialModels.ENGINE_LINKAGE, blockState, facing, roll90).center().translate(0, 1, 0).uncenter()
            .translate(0, piston + 20 / 16f, 0).translate(0, 4 / 16f, 8 / 16f).rotateX(angle2).translate(0, -4 / 16f, -8 / 16f).light(light)
            .renderInto(ms, vb);

        transformed(AllPartialModels.ENGINE_CONNECTOR, blockState, facing, roll90).translate(0, 2, 0).center().rotateX(-(angle + class_3532.field_29845))
            .uncenter().light(light).renderInto(ms, vb);
    }

    private SuperByteBuffer transformed(PartialModel model, class_2680 blockState, class_2350 facing, boolean roll90) {
        return CachedBuffers.partial(model, blockState).center().rotateYDegrees(AngleHelper.horizontalAngle(facing))
            .rotateXDegrees(AngleHelper.verticalAngle(facing) + 90).rotateYDegrees(roll90 ? -90 : 0).uncenter();
    }

    @Override
    public int method_33893() {
        return 128;
    }

    @Nullable
    public static Float getTargetAngle(SteamEngineBlockEntity be) {
        class_2680 blockState = be.method_11010();
        if (!blockState.method_27852(AllBlocks.STEAM_ENGINE))
            return null;

        class_2350 facing = SteamEngineBlock.getFacing(blockState);
        PoweredShaftBlockEntity shaft = be.getShaft();
        class_2351 facingAxis = facing.method_10166();

        if (shaft == null)
            return null;

        class_2351 axis = KineticBlockEntityRenderer.getRotationAxisOf(shaft);
        float angle = KineticBlockEntityRenderer.getAngleForBe(shaft, shaft.method_11016(), axis);

        if (axis == facingAxis)
            return null;
        if (axis.method_10179() && (facingAxis == class_2351.field_11048 ^ facing.method_10171() == class_2350.class_2352.field_11056))
            angle *= -1;
        if (axis == class_2351.field_11048 && facing == class_2350.field_11033)
            angle *= -1;
        return angle;
    }
}
