package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class FactoryPanelSlotPositioning extends ValueBoxTransform {

    public PanelSlot slot;

    public FactoryPanelSlotPositioning(PanelSlot slot) {
        this.slot = slot;
    }

    @Override
    public class_243 getLocalOffset(class_1936 level, class_2338 pos, class_2680 state) {
        return getCenterOfSlot(state, slot);
    }

    public static class_243 getCenterOfSlot(class_2680 state, PanelSlot slot) {
        class_243 vec = new class_243(.25 + slot.xOffset * .5, 1.5 / 16f, .25 + slot.yOffset * .5);
        vec = VecHelper.rotateCentered(vec, 180, class_2351.field_11052);
        vec = VecHelper.rotateCentered(vec, class_3532.field_29848 * FactoryPanelBlock.getXRot(state) + 90, class_2351.field_11048);
        vec = VecHelper.rotateCentered(vec, class_3532.field_29848 * FactoryPanelBlock.getYRot(state), class_2351.field_11052);
        return vec;
    }

    @Override
    public boolean testHit(class_1936 level, class_2338 pos, class_2680 state, class_243 localHit) {
        class_243 offset = getLocalOffset(level, pos, state);
        if (offset == null)
            return false;
        return localHit.method_1022(offset) < scale / 2;
    }

    @Override
    public float getScale() {
        return super.getScale();
    }

    @Override
    public void rotate(class_1936 level, class_2338 pos, class_2680 state, class_4587 ms) {
        TransformStack.of(ms).rotate(FactoryPanelBlock.getYRot(state) + class_3532.field_29844, class_2350.field_11036)
            .rotate(-FactoryPanelBlock.getXRot(state), class_2350.field_11034);
    }

}
