package com.zurrtum.create.client.content.logistics.filter;

import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.filter.AttributeFilterMenu;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttributeType;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.component.AttributeFilterWhitelistMode;
import com.zurrtum.create.infrastructure.component.ItemAttributeEntry;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class AttributeFilterScreen extends AbstractFilterScreen<AttributeFilterMenu> {

    private static final String PREFIX = "gui.attribute_filter.";

    private final class_2561 addDESC = CreateLang.translateDirect(PREFIX + "add_attribute");
    private final class_2561 addInvertedDESC = CreateLang.translateDirect(PREFIX + "add_inverted_attribute");

    private final class_2561 allowDisN = CreateLang.translateDirect(PREFIX + "allow_list_disjunctive");
    private final class_2561 allowDisDESC = CreateLang.translateDirect(PREFIX + "allow_list_disjunctive.description");
    private final class_2561 allowConN = CreateLang.translateDirect(PREFIX + "allow_list_conjunctive");
    private final class_2561 allowConDESC = CreateLang.translateDirect(PREFIX + "allow_list_conjunctive.description");
    private final class_2561 denyN = CreateLang.translateDirect(PREFIX + "deny_list");
    private final class_2561 denyDESC = CreateLang.translateDirect(PREFIX + "deny_list.description");

    private final class_2561 referenceH = CreateLang.translateDirect(PREFIX + "add_reference_item");
    private final class_2561 noSelectedT = CreateLang.translateDirect(PREFIX + "no_selected_attributes");
    private final class_2561 selectedT = CreateLang.translateDirect(PREFIX + "selected_attributes");

    private IconButton whitelistDis, whitelistCon, blacklist;
    private IconButton add;
    private IconButton addInverted;

    private class_1799 lastItemScanned = class_1799.field_8037;
    private final List<ItemAttribute> attributesOfItem = new ArrayList<>();
    private final List<class_2561> selectedAttributes = new ArrayList<>();
    private SelectionScrollInput attributeSelector;
    private Label attributeSelectorLabel;

    public AttributeFilterScreen(AttributeFilterMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, title, AllGuiTextures.ATTRIBUTE_FILTER);
    }

    public static AttributeFilterScreen create(
        class_310 mc,
        MenuType<class_1799> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        return type.create(AttributeFilterScreen::new, syncId, inventory, title, getStack(extraData));
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (method_19355(mouseX, mouseY).filter(element -> element.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)).isPresent()) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    protected void method_25426() {
        setWindowOffset(-11, 7);
        super.method_25426();

        whitelistDis = new IconButton(field_2776 + 38, field_2800 + 61, AllIcons.I_WHITELIST_OR);
        whitelistDis.withCallback(() -> {
            field_2797.whitelistMode = AttributeFilterWhitelistMode.WHITELIST_DISJ;
            sendOptionUpdate(Option.WHITELIST);
        });
        whitelistDis.setToolTip(allowDisN);
        whitelistCon = new IconButton(field_2776 + 56, field_2800 + 61, AllIcons.I_WHITELIST_AND);
        whitelistCon.withCallback(() -> {
            field_2797.whitelistMode = AttributeFilterWhitelistMode.WHITELIST_CONJ;
            sendOptionUpdate(Option.WHITELIST2);
        });
        whitelistCon.setToolTip(allowConN);
        blacklist = new IconButton(field_2776 + 74, field_2800 + 61, AllIcons.I_WHITELIST_NOT);
        blacklist.withCallback(() -> {
            field_2797.whitelistMode = AttributeFilterWhitelistMode.BLACKLIST;
            sendOptionUpdate(Option.BLACKLIST);
        });
        blacklist.setToolTip(denyN);

        addRenderableWidgets(blacklist, whitelistCon, whitelistDis);

        method_37063(add = new IconButton(field_2776 + 182, field_2800 + 26, AllIcons.I_ADD));
        method_37063(addInverted = new IconButton(field_2776 + 200, field_2800 + 26, AllIcons.I_ADD_INVERTED_ATTRIBUTE));
        add.withCallback(() -> {
            handleAddedAttibute(false);
        });
        add.setToolTip(addDESC);
        addInverted.withCallback(() -> {
            handleAddedAttibute(true);
        });
        addInverted.setToolTip(addInvertedDESC);

        handleIndicators();

        attributeSelectorLabel = new Label(field_2776 + 43, field_2800 + 31, class_5244.field_39003).colored(0xFFF3EBDE).withShadow();
        attributeSelector = new SelectionScrollInput(field_2776 + 39, field_2800 + 26, 137, 18);
        attributeSelector.forOptions(Arrays.asList(class_5244.field_39003));
        attributeSelector.removeCallback();
        referenceItemChanged(field_2797.ghostInventory.method_5438(0));

        method_37063(attributeSelector);
        method_37063(attributeSelectorLabel);

        selectedAttributes.clear();
        selectedAttributes.add((field_2797.selectedAttributes.isEmpty() ? noSelectedT : selectedT).method_27662().method_27692(class_124.field_1054));
        field_2797.selectedAttributes.forEach(at -> {
            selectedAttributes.add(class_2561.method_43470("- ").method_10852(at.attribute().format(at.inverted())).method_27692(class_124.field_1080));
        });
    }

    private void referenceItemChanged(class_1799 stack) {
        class_7225.class_7874 registries = field_22787.field_1687.method_30349();
        lastItemScanned = stack;

        if (stack.method_7960()) {
            attributeSelector.field_22763 = false;
            attributeSelector.field_22764 = false;
            attributeSelectorLabel.text = referenceH.method_27662().method_27692(class_124.field_1056);
            add.field_22763 = false;
            addInverted.field_22763 = false;
            attributeSelector.calling(s -> {
            });
            return;
        }

        add.field_22763 = true;

        addInverted.field_22763 = true;
        attributeSelector.titled(CreateLang.text(stack.method_7964().getString() + "...").color(ScrollInput.HEADER_RGB.getRGB()).component());
        attributesOfItem.clear();
        for (ItemAttributeType type : CreateRegistries.ITEM_ATTRIBUTE_TYPE)
            attributesOfItem.addAll(type.getAllAttributes(stack, field_22787.field_1687));
        List<class_2561> options = attributesOfItem.stream().map(a -> a.format(false)).collect(Collectors.toList());
        attributeSelector.forOptions(options);
        attributeSelector.field_22763 = true;
        attributeSelector.field_22764 = true;
        attributeSelector.setState(0);
        attributeSelector.calling(i -> {
            attributeSelectorLabel.setTextAndTrim(options.get(i), true, 112);
            ItemAttribute selected = attributesOfItem.get(i);
            for (ItemAttributeEntry existing : field_2797.selectedAttributes) {
                class_2487 testTag = ItemAttribute.saveStatic(existing.attribute(), registries);
                class_2487 testTag2 = ItemAttribute.saveStatic(selected, registries);
                if (testTag.equals(testTag2)) {
                    add.field_22763 = false;
                    addInverted.field_22763 = false;
                    return;
                }
            }
            add.field_22763 = true;
            addInverted.field_22763 = true;
        });
        attributeSelector.onChanged();
    }

    @Override
    public void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_1799 stack = field_2797.ghostInventory.method_5438(1);
        graphics.method_51432(field_22793, stack, field_2776 + 16, field_2800 + 62, String.valueOf(selectedAttributes.size() - 1));

        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        class_1799 stackInSlot = field_2797.ghostInventory.method_5438(0);
        if (!class_1799.method_7973(stackInSlot, lastItemScanned))
            referenceItemChanged(stackInSlot);
    }

    @Override
    protected void method_2380(class_332 graphics, int mouseX, int mouseY) {
        if (field_2797.method_34255().method_7960() && field_2787 != null && field_2787.method_7681()) {
            if (field_2787.field_7874 == 37) {
                graphics.method_51434(field_22793, selectedAttributes, mouseX, mouseY);
                return;
            }
            graphics.method_51446(field_22793, field_2787.method_7677(), mouseX, mouseY);
        }
        super.method_2380(graphics, mouseX, mouseY);
    }

    @Override
    protected List<IconButton> getTooltipButtons() {
        return Arrays.asList(blacklist, whitelistCon, whitelistDis);
    }

    @Override
    protected List<class_5250> getTooltipDescriptions() {
        return Arrays.asList(denyDESC.method_27662(), allowConDESC.method_27662(), allowDisDESC.method_27662());
    }

    protected boolean handleAddedAttibute(boolean inverted) {
        int index = attributeSelector.getState();
        if (index >= attributesOfItem.size())
            return false;
        add.field_22763 = false;
        addInverted.field_22763 = false;
        ItemAttribute itemAttribute = attributesOfItem.get(index);
        class_2487 tag = ItemAttribute.saveStatic(itemAttribute, field_22787.field_1687.method_30349());
        field_22787.field_1724.field_3944.method_52787(new FilterScreenPacket(inverted ? Option.ADD_INVERTED_TAG : Option.ADD_TAG, tag));
        field_2797.appendSelectedAttribute(itemAttribute, inverted);
        if (field_2797.selectedAttributes.size() == 1)
            selectedAttributes.set(0, selectedT.method_27662().method_27692(class_124.field_1054));
        selectedAttributes.add(class_2561.method_43470("- ").method_10852(itemAttribute.format(inverted)).method_27692(class_124.field_1080));
        return true;
    }

    @Override
    protected void contentsCleared() {
        selectedAttributes.clear();
        selectedAttributes.add(noSelectedT.method_27662().method_27692(class_124.field_1054));
        if (!lastItemScanned.method_7960()) {
            add.field_22763 = true;
            addInverted.field_22763 = true;
        }
    }

    @Override
    protected boolean isButtonEnabled(IconButton button) {
        if (button == blacklist)
            return field_2797.whitelistMode != AttributeFilterWhitelistMode.BLACKLIST;
        if (button == whitelistCon)
            return field_2797.whitelistMode != AttributeFilterWhitelistMode.WHITELIST_CONJ;
        if (button == whitelistDis)
            return field_2797.whitelistMode != AttributeFilterWhitelistMode.WHITELIST_DISJ;
        return true;
    }

}
