package com.zurrtum.create.client.content.redstone;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.redstone.DirectedDirectionalBlock;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;

public class FilteredDetectorFilterSlot extends ValueBoxTransform.Sided {

    private final boolean hasSlotAtBottom;

    public FilteredDetectorFilterSlot(boolean hasSlotAtBottom) {
        this.hasSlotAtBottom = hasSlotAtBottom;
    }

    @Override
    protected boolean isSideActive(class_2680 state, class_2350 direction) {
        class_2350 targetDirection = DirectedDirectionalBlock.getTargetDirection(state);
        if (direction == targetDirection)
            return false;
        if (targetDirection.method_10153() == direction)
            return true;

        if (targetDirection.method_10166() != class_2351.field_11052)
            return direction == class_2350.field_11036 || direction == class_2350.field_11033 && hasSlotAtBottom;
        if (targetDirection == class_2350.field_11036)
            direction = direction.method_10153();
        if (!hasSlotAtBottom)
            return direction == state.method_11654(DirectedDirectionalBlock.field_11177);

        return direction.method_10166() == state.method_11654(DirectedDirectionalBlock.field_11177).method_10170().method_10166();
    }

    @Override
    public void rotate(class_1936 level, class_2338 pos, class_2680 state, class_4587 ms) {
        super.rotate(level, pos, state, ms);
        class_2350 facing = state.method_11654(DirectedDirectionalBlock.field_11177);
        if (facing.method_10166() == class_2351.field_11052)
            return;
        if (getSide() != class_2350.field_11036)
            return;
        TransformStack.of(ms).rotateZDegrees(-AngleHelper.horizontalAngle(facing) + 180);
    }

    @Override
    protected class_243 getSouthLocation() {
        return VecHelper.voxelSpace(8f, 8f, 15.5f);
    }

}
