package com.zurrtum.create.client.content.redstone.link;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.redstone.link.RedstoneLinkBlock;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;

public class RedstoneLinkFrequencySlot extends ValueBoxTransform.Dual {

    public RedstoneLinkFrequencySlot(boolean first) {
        super(first);
    }

    class_243 horizontal = VecHelper.voxelSpace(10f, 5.5f, 2.5f);
    class_243 vertical = VecHelper.voxelSpace(10f, 2.5f, 5.5f);

    @Override
    public class_243 getLocalOffset(class_1936 level, class_2338 pos, class_2680 state) {
        class_2350 facing = state.method_11654(RedstoneLinkBlock.field_10927);
        class_243 location = VecHelper.voxelSpace(8f, 3.01f, 5.5f);

        if (facing.method_10166().method_10179()) {
            location = VecHelper.voxelSpace(8f, 5.5f, 3.01f);
            if (isFirst())
                location = location.method_1031(0, 5 / 16f, 0);
            return rotateHorizontally(state, location);
        }

        if (isFirst())
            location = location.method_1031(0, 0, 5 / 16f);
        location = VecHelper.rotateCentered(location, facing == class_2350.field_11033 ? 180 : 0, class_2351.field_11048);
        return location;
    }

    @Override
    public void rotate(class_1936 level, class_2338 pos, class_2680 state, class_4587 ms) {
        class_2350 facing = state.method_11654(RedstoneLinkBlock.field_10927);
        float yRot = facing.method_10166().method_10178() ? 0 : AngleHelper.horizontalAngle(facing) + 180;
        float xRot = facing == class_2350.field_11036 ? 90 : facing == class_2350.field_11033 ? 270 : 0;
        TransformStack.of(ms).rotateYDegrees(yRot).rotateXDegrees(xRot);
    }

    @Override
    public float getScale() {
        return .4975f;
    }

}

