package com.zurrtum.create.client.content.schematics.cannon;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.FontHelper.Palette;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Indicator;
import com.zurrtum.create.client.foundation.gui.widget.Indicator.State;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.zurrtum.create.content.schematics.cannon.SchematicannonMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSchematicannonPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSchematicannonPacket.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_768;
import net.minecraft.class_8942;
import net.minecraft.class_9129;

import static com.zurrtum.create.Create.LOGGER;

public class SchematicannonScreen extends AbstractSimiContainerScreen<SchematicannonMenu> {

    private static final AllGuiTextures BG_BOTTOM = AllGuiTextures.SCHEMATICANNON_BOTTOM;
    private static final AllGuiTextures BG_TOP = AllGuiTextures.SCHEMATICANNON_TOP;

    private final class_2561 listPrinter = CreateLang.translateDirect("gui.schematicannon.listPrinter");
    private final String _gunpowderLevel = "gui.schematicannon.gunpowderLevel";
    private final String _shotsRemaining = "gui.schematicannon.shotsRemaining";
    private final String _showSettings = "gui.schematicannon.showOptions";
    private final String _shotsRemainingWithBackup = "gui.schematicannon.shotsRemainingWithBackup";

    private final String _slotGunpowder = "gui.schematicannon.slot.gunpowder";
    private final String _slotListPrinter = "gui.schematicannon.slot.listPrinter";
    private final String _slotSchematic = "gui.schematicannon.slot.schematic";

    private final class_2561 optionEnabled = CreateLang.translateDirect("gui.schematicannon.optionEnabled");
    private final class_2561 optionDisabled = CreateLang.translateDirect("gui.schematicannon.optionDisabled");

    protected List<Indicator> replaceLevelIndicators;
    protected List<IconButton> replaceLevelButtons;

    protected IconButton skipMissingButton;
    protected Indicator skipMissingIndicator;
    protected IconButton skipBlockEntitiesButton;
    protected Indicator skipBlockEntitiesIndicator;

    protected IconButton playButton;
    protected Indicator playIndicator;
    protected IconButton pauseButton;
    protected Indicator pauseIndicator;
    protected IconButton resetButton;
    protected Indicator resetIndicator;

    private IconButton confirmButton;
    private IconButton showSettingsButton;
    private Indicator showSettingsIndicator;
    private ElementWidget renderedItem;

    protected List<class_339> placementSettingWidgets;

    private List<class_768> extraAreas = Collections.emptyList();

    public SchematicannonScreen(SchematicannonMenu menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title);
        placementSettingWidgets = new ArrayList<>();
    }

    public static SchematicannonScreen create(
        class_310 mc,
        MenuType<SchematicannonBlockEntity> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        SchematicannonBlockEntity entity = getBlockEntity(mc, extraData);
        if (entity == null) {
            return null;
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(entity.method_71402(), LOGGER)) {
            class_11368 view = class_11352.method_71417(logging, extraData.method_56349(), extraData.method_10798());
            entity.readClient(view);
            return type.create(SchematicannonScreen::new, syncId, inventory, title, entity);
        }
    }

    @Override
    protected void method_25426() {
        setWindowSize(BG_TOP.getWidth(), BG_TOP.getHeight() + BG_BOTTOM.getHeight() + 2 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        setWindowOffset(-11, 0);
        super.method_25426();

        // Play Pause Stop
        playButton = new IconButton(field_2776 + 75, field_2800 + 85, AllIcons.I_PLAY);
        playButton.withCallback(() -> {
            sendOptionUpdate(Option.PLAY, true);
        });
        playIndicator = new Indicator(field_2776 + 75, field_2800 + 79, class_5244.field_39003);
        pauseButton = new IconButton(field_2776 + 93, field_2800 + 85, AllIcons.I_PAUSE);
        pauseButton.withCallback(() -> {
            sendOptionUpdate(Option.PAUSE, true);
        });
        pauseIndicator = new Indicator(field_2776 + 93, field_2800 + 79, class_5244.field_39003);
        resetButton = new IconButton(field_2776 + 111, field_2800 + 85, AllIcons.I_STOP);
        resetButton.withCallback(() -> {
            sendOptionUpdate(Option.STOP, true);
        });
        resetIndicator = new Indicator(field_2776 + 111, field_2800 + 79, class_5244.field_39003);
        resetIndicator.state = State.RED;
        addRenderableWidgets(playButton, playIndicator, pauseButton, pauseIndicator, resetButton, resetIndicator);

        confirmButton = new IconButton(field_2776 + 180, field_2800 + 111, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> {
            field_22787.field_1724.method_7346();
        });
        method_37063(confirmButton);
        showSettingsButton = new IconButton(field_2776 + 8, field_2800 + 111, AllIcons.I_PLACEMENT_SETTINGS);
        showSettingsButton.withCallback(() -> {
            showSettingsIndicator.state = placementSettingsHidden() ? State.GREEN : State.OFF;
            initPlacementSettings();
        });
        showSettingsButton.setToolTip(CreateLang.translateDirect(_showSettings));
        method_37063(showSettingsButton);
        showSettingsIndicator = new Indicator(field_2776 + 9, field_2800 + 111, class_5244.field_39003);
        //		addRenderableWidget(showSettingsIndicator);

        extraAreas = ImmutableList.of(new class_768(field_2776 + BG_TOP.getWidth(), field_2800 + BG_TOP.getHeight() + BG_BOTTOM.getHeight() - 62, 84, 92));

        renderedItem = new ElementWidget(field_2776 + BG_TOP.getWidth() - 14, field_2800 + BG_TOP.getHeight() + BG_BOTTOM.getHeight() - 62).showingElement(
            GuiGameElement.of(AllItems.SCHEMATICANNON.method_7854()).scale(5).padding(28));
        method_37063(renderedItem);

        method_25393();
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    private void initPlacementSettings() {
        removeWidgets(placementSettingWidgets);
        placementSettingWidgets.clear();

        if (placementSettingsHidden())
            return;

        // Replace settings
        replaceLevelButtons = new ArrayList<>(4);
        replaceLevelIndicators = new ArrayList<>(4);
        List<AllIcons> icons = ImmutableList.of(AllIcons.I_DONT_REPLACE, AllIcons.I_REPLACE_SOLID, AllIcons.I_REPLACE_ANY, AllIcons.I_REPLACE_EMPTY);
        List<class_2561> toolTips = ImmutableList.of(
            CreateLang.translateDirect("gui.schematicannon.option.dontReplaceSolid"),
            CreateLang.translateDirect("gui.schematicannon.option.replaceWithSolid"),
            CreateLang.translateDirect("gui.schematicannon.option.replaceWithAny"),
            CreateLang.translateDirect("gui.schematicannon.option.replaceWithEmpty")
        );

        for (int i = 0; i < 4; i++) {
            replaceLevelIndicators.add(new Indicator(field_2776 + 33 + i * 18, field_2800 + 111, class_5244.field_39003));
            IconButton replaceLevelButton = new IconButton(field_2776 + 33 + i * 18, field_2800 + 111, icons.get(i));
            int replaceMode = i;
            replaceLevelButton.withCallback(() -> {
                if (field_2797.contentHolder.replaceMode != replaceMode)
                    sendOptionUpdate(Option.values()[replaceMode], true);
            });
            replaceLevelButton.setToolTip(toolTips.get(i));
            replaceLevelButtons.add(replaceLevelButton);
        }
        placementSettingWidgets.addAll(replaceLevelButtons);
        //		placementSettingWidgets.addAll(replaceLevelIndicators);

        // Other Settings
        skipMissingButton = new IconButton(field_2776 + 111, field_2800 + 111, AllIcons.I_SKIP_MISSING);
        skipMissingButton.withCallback(() -> {
            sendOptionUpdate(Option.SKIP_MISSING, !field_2797.contentHolder.skipMissing);
        });
        skipMissingButton.setToolTip(CreateLang.translateDirect("gui.schematicannon.option.skipMissing"));
        skipMissingIndicator = new Indicator(field_2776 + 111, field_2800 + 111, class_5244.field_39003);
        Collections.addAll(placementSettingWidgets, skipMissingButton);

        skipBlockEntitiesButton = new IconButton(field_2776 + 135, field_2800 + 111, AllIcons.I_SKIP_BLOCK_ENTITIES);
        skipBlockEntitiesButton.withCallback(() -> {
            sendOptionUpdate(Option.SKIP_BLOCK_ENTITIES, !field_2797.contentHolder.replaceBlockEntities);
        });
        skipBlockEntitiesButton.setToolTip(CreateLang.translateDirect("gui.schematicannon.option.skipBlockEntities"));
        skipBlockEntitiesIndicator = new Indicator(field_2776 + 129, field_2800 + 111, class_5244.field_39003);
        Collections.addAll(placementSettingWidgets, skipBlockEntitiesButton);

        addRenderableWidgets(placementSettingWidgets);
    }

    protected boolean placementSettingsHidden() {
        return showSettingsIndicator.state == State.OFF;
    }

    @Override
    protected void method_37432() {
        super.method_37432();

        SchematicannonBlockEntity be = field_2797.contentHolder;

        if (!placementSettingsHidden()) {
            for (int replaceMode = 0; replaceMode < replaceLevelButtons.size(); replaceMode++) {
                replaceLevelButtons.get(replaceMode).green = replaceMode == be.replaceMode;
                replaceLevelIndicators.get(replaceMode).state = replaceMode == be.replaceMode ? State.ON : State.OFF;
            }
            skipMissingButton.green = be.skipMissing;
            skipBlockEntitiesButton.green = !be.replaceBlockEntities;
        }

        playIndicator.state = State.OFF;
        pauseIndicator.state = State.OFF;
        resetIndicator.state = State.OFF;

        switch (be.state) {
            case PAUSED:
                pauseIndicator.state = State.YELLOW;
                playButton.field_22763 = true;
                pauseButton.field_22763 = false;
                resetButton.field_22763 = true;
                break;
            case RUNNING:
                playIndicator.state = State.GREEN;
                playButton.field_22763 = false;
                pauseButton.field_22763 = true;
                resetButton.field_22763 = true;
                break;
            case STOPPED:
                resetIndicator.state = State.RED;
                playButton.field_22763 = true;
                pauseButton.field_22763 = false;
                resetButton.field_22763 = false;
                break;
            default:
                break;
        }

        handleTooltips();
    }

    protected void handleTooltips() {
        if (placementSettingsHidden())
            return;

        for (class_339 w : placementSettingWidgets)
            if (w instanceof IconButton button) {
                if (!button.getToolTip().isEmpty()) {
                    button.setToolTip(button.getToolTip().getFirst());
                    button.getToolTip().add(TooltipHelper.holdShift(Palette.BLUE, method_25442()));
                }
            }

        if (method_25442()) {
            fillToolTip(skipMissingButton, skipMissingIndicator, "skipMissing");
            fillToolTip(skipBlockEntitiesButton, skipBlockEntitiesIndicator, "skipBlockEntities");
            fillToolTip(replaceLevelButtons.get(0), replaceLevelIndicators.get(0), "dontReplaceSolid");
            fillToolTip(replaceLevelButtons.get(1), replaceLevelIndicators.get(1), "replaceWithSolid");
            fillToolTip(replaceLevelButtons.get(2), replaceLevelIndicators.get(2), "replaceWithAny");
            fillToolTip(replaceLevelButtons.get(3), replaceLevelIndicators.get(3), "replaceWithEmpty");
        }
    }

    private void fillToolTip(IconButton button, Indicator indicator, String tooltipKey) {
        if (!button.method_49606())
            return;
        boolean enabled = button.green;
        List<class_2561> tip = button.getToolTip();
        tip.add((enabled ? optionEnabled : optionDisabled).method_27662().method_27692(enabled ? class_124.field_1077 : class_124.field_1061));
        tip.addAll(TooltipHelper.cutTextComponent(
            CreateLang.translateDirect("gui.schematicannon.option." + tooltipKey + ".description"),
            Palette.ALL_GRAY
        ));
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = field_2800 + BG_TOP.getHeight() + BG_BOTTOM.getHeight() + 2;
        renderPlayerInventory(graphics, invX, invY);

        BG_TOP.render(graphics, field_2776, field_2800);
        BG_BOTTOM.render(graphics, field_2776, field_2800 + BG_TOP.getHeight());
        AllGuiTextures.SCHEMATIC_TITLE.render(graphics, field_2776, field_2800 - 2);

        SchematicannonBlockEntity be = field_2797.contentHolder;
        renderPrintingProgress(graphics, field_2776, field_2800, be.schematicProgress);
        float amount = be.remainingFuel / (float) be.getShotsPerGunpowder();
        renderFuelBar(graphics, field_2776, field_2800, amount);
        renderChecklistPrinterProgress(graphics, field_2776, field_2800, be.bookPrintingProgress);

        if (!be.inventory.method_5438(0).method_7960())
            renderBlueprintHighlight(graphics, field_2776, field_2800);

        graphics.method_51439(field_22793, field_22785, field_2776 + (BG_TOP.getWidth() - 8 - field_22793.method_27525(field_22785)) / 2, field_2800 + 2, 0xFF505050, false);

        class_2561 msg = CreateLang.translateDirect("schematicannon.status." + be.statusMsg);
        int stringWidth = field_22793.method_27525(msg);

        if (be.missingItem != null) {
            stringWidth += 16;
            graphics.method_51427(be.missingItem, field_2776 + 128, field_2800 + 49);
        }

        graphics.method_51439(field_22793, msg, field_2776 + 103 - stringWidth / 2, field_2800 + 53, 0xFFDDEEFF, true);

        if ("schematicErrored".equals(be.statusMsg))
            graphics.method_51439(
                field_22793,
                CreateLang.translateDirect("schematicannon.status.schematicErroredCheckLogs"),
                field_2776 + 103 - stringWidth / 2,
                field_2800 + 65,
                0xFFDDEEFF,
                true
            );
    }

    protected void renderBlueprintHighlight(class_332 graphics, int x, int y) {
        AllGuiTextures.SCHEMATICANNON_HIGHLIGHT.render(graphics, x + 10, y + 60);
    }

    protected void renderPrintingProgress(class_332 graphics, int x, int y, float progress) {
        progress = Math.min(progress, 1);
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_PROGRESS;
        graphics.method_25290(
            class_10799.field_56883,
            sprite.location,
            x + 44,
            y + 64,
            sprite.getStartX(),
            sprite.getStartY(),
            (int) (sprite.getWidth() * progress),
            sprite.getHeight(),
            256,
            256
        );
    }

    protected void renderChecklistPrinterProgress(class_332 graphics, int x, int y, float progress) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_CHECKLIST_PROGRESS;
        graphics.method_25290(
            class_10799.field_56883,
            sprite.location,
            x + 154,
            y + 20,
            sprite.getStartX(),
            sprite.getStartY(),
            (int) (sprite.getWidth() * progress),
            sprite.getHeight(),
            256,
            256
        );
    }

    protected void renderFuelBar(class_332 graphics, int x, int y, float amount) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_FUEL;
        if (field_2797.contentHolder.hasCreativeCrate) {
            AllGuiTextures.SCHEMATICANNON_FUEL_CREATIVE.render(graphics, x + 36, y + 19);
            return;
        }
        graphics.method_25290(
            class_10799.field_56883,
            sprite.location,
            x + 36,
            y + 19,
            sprite.getStartX(),
            sprite.getStartY(),
            (int) (sprite.getWidth() * amount),
            sprite.getHeight(),
            256,
            256
        );
    }

    @Override
    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        SchematicannonBlockEntity be = field_2797.contentHolder;

        int fuelX = field_2776 + 36, fuelY = field_2800 + 19;
        if (mouseX >= fuelX && mouseY >= fuelY && mouseX <= fuelX + AllGuiTextures.SCHEMATICANNON_FUEL.getWidth() && mouseY <= fuelY + AllGuiTextures.SCHEMATICANNON_FUEL.getHeight()) {
            List<class_2561> tooltip = getFuelLevelTooltip(be);
            graphics.method_51434(field_22793, tooltip, mouseX, mouseY);
        }

        if (field_2787 != null && !field_2787.method_7681()) {
            String tooltipKey = switch (field_2787.field_7874) {
                case 0 -> _slotSchematic;
                case 2 -> _slotListPrinter;
                case 4 -> _slotGunpowder;
                default -> null;
            };
            if (tooltipKey != null) {
                graphics.method_51434(
                    field_22793,
                    TooltipHelper.cutTextComponent(CreateLang.translateDirect(tooltipKey), Palette.GRAY_AND_BLUE),
                    mouseX,
                    mouseY
                );
            }
        }

        if (be.missingItem != null) {
            int missingBlockX = field_2776 + 128, missingBlockY = field_2800 + 49;
            if (mouseX >= missingBlockX && mouseY >= missingBlockY && mouseX <= missingBlockX + 16 && mouseY <= missingBlockY + 16) {
                graphics.method_51446(field_22793, be.missingItem, mouseX, mouseY);
            }
        }

        int paperX = field_2776 + 112, paperY = field_2800 + 19;
        if (mouseX >= paperX && mouseY >= paperY && mouseX <= paperX + 16 && mouseY <= paperY + 16)
            graphics.method_51438(field_22793, listPrinter, mouseX, mouseY);

        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    protected List<class_2561> getFuelLevelTooltip(SchematicannonBlockEntity be) {
        int shotsLeft = be.remainingFuel;
        int shotsLeftWithItems = shotsLeft + be.inventory.method_5438(4).method_7947() * be.getShotsPerGunpowder();
        List<class_2561> tooltip = new ArrayList<>();

        if (be.hasCreativeCrate) {
            tooltip.add(CreateLang.translateDirect(_gunpowderLevel, "" + 100));
            tooltip.add(class_2561.method_43470("(").method_10852(AllItems.CREATIVE_CRATE.method_63680()).method_27693(")").method_27692(class_124.field_1064));
            return tooltip;
        }

        int fillPercent = (int) ((be.remainingFuel / (float) be.getShotsPerGunpowder()) * 100);
        tooltip.add(CreateLang.translateDirect(_gunpowderLevel, fillPercent));
        tooltip.add(CreateLang.translateDirect(_shotsRemaining, class_2561.method_43470(Integer.toString(shotsLeft)).method_27692(class_124.field_1078))
            .method_27692(class_124.field_1080));
        if (shotsLeftWithItems != shotsLeft) {
            tooltip.add(CreateLang.translateDirect(
                _shotsRemainingWithBackup,
                class_2561.method_43470(Integer.toString(shotsLeftWithItems)).method_27692(class_124.field_1078)
            ).method_27692(class_124.field_1080));
        }

        return tooltip;
    }

    protected void sendOptionUpdate(Option option, boolean set) {
        field_22787.field_1724.field_3944.method_52787(new ConfigureSchematicannonPacket(option, set));
    }

    @Override
    public List<class_768> getExtraAreas() {
        return extraAreas;
    }

}
