package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.ShadedBlockSbbBuilder;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.foundation.render.BlockEntityRenderHelper;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.*;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;

public class SchematicRenderer {

    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    private final Map<class_11515, SuperByteBuffer> bufferCache = new LinkedHashMap<>(class_11515.values().length);
    private boolean changed;
    protected final SchematicLevel schematic;
    private final class_2338 anchor;
    private final List<class_2586> renderedBlockEntities = new ArrayList<>();
    private final BitSet shouldRenderBlockEntities = new BitSet();
    private final BitSet scratchErroredBlockEntities = new BitSet();

    public SchematicRenderer(SchematicLevel world) {
        this.anchor = world.anchor;
        this.schematic = world;
        this.changed = true;

        for (var renderedBlockEntity : schematic.getRenderedBlockEntities()) {
            renderedBlockEntities.add(renderedBlockEntity);
        }
        shouldRenderBlockEntities.set(0, renderedBlockEntities.size());
    }

    public void update() {
        changed = true;
    }

    public void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffers) {
        if (mc.field_1687 == null || mc.field_1724 == null)
            return;
        if (changed)
            redraw(mc);
        changed = false;

        bufferCache.forEach((layer, buffer) -> {
            buffer.renderInto(ms, buffers.getBuffer(layer));
        });
        scratchErroredBlockEntities.clear();
        BlockEntityRenderHelper.renderBlockEntities(
            renderedBlockEntities,
            shouldRenderBlockEntities,
            scratchErroredBlockEntities,
            null,
            schematic,
            ms,
            null,
            buffers,
            AnimationTickHolder.getPartialTicks()
        );

        // Don't bother looping over errored BEs again.
        shouldRenderBlockEntities.andNot(scratchErroredBlockEntities);
    }

    protected void redraw(class_310 mc) {
        bufferCache.clear();

        for (class_11515 layer : class_11515.values()) {
            SuperByteBuffer buffer = drawLayer(mc, layer);
            if (!buffer.isEmpty())
                bufferCache.put(layer, buffer);
        }
    }

    @SuppressWarnings("removal")
    protected SuperByteBuffer drawLayer(class_310 mc, class_11515 layer) {
        class_776 dispatcher = mc.method_1541();
        class_778 renderer = dispatcher.method_3350();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();

        class_4587 poseStack = objects.poseStack;
        class_5819 random = objects.random;
        class_2338.class_2339 mutableBlockPos = objects.mutableBlockPos;
        SchematicLevel renderWorld = schematic;
        class_3341 bounds = renderWorld.getBounds();

        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();

        renderWorld.renderMode = true;
        class_778.method_20544();
        for (class_2338 localPos : class_2338.method_10094(
            bounds.method_35415(),
            bounds.method_35416(),
            bounds.method_35417(),
            bounds.method_35418(),
            bounds.method_35419(),
            bounds.method_35420()
        )) {
            class_2338 pos = mutableBlockPos.method_35831(localPos, anchor);
            class_2680 state = renderWorld.method_8320(pos);

            if (state.method_26217() == class_2464.field_11458 && class_4696.method_23679(state) == layer) {
                long seed = state.method_26190(pos);
                class_1087 model = dispatcher.method_3349(state);
                random.method_43052(seed);
                poseStack.method_22903();
                poseStack.method_46416(localPos.method_10263(), localPos.method_10264(), localPos.method_10260());
                List<class_10889> parts = new ObjectArrayList<>();
                if (WrapperBlockStateModel.unwrapCompat(model) instanceof WrapperBlockStateModel wrapper) {
                    wrapper.addPartsWithInfo(renderWorld, pos, state, random, parts);
                } else {
                    model.method_68513(random, parts);
                }
                renderer.method_3374(renderWorld, parts, state, pos, poseStack, sbbBuilder, true, class_4608.field_21444);
                poseStack.method_22909();
            }
        }
        class_778.method_20545();
        renderWorld.renderMode = false;

        return sbbBuilder.end();
    }

    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        @SuppressWarnings("removal")
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();
    }

}
