package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline.BezierPointSelection;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TrainRelocator;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import com.zurrtum.create.infrastructure.packet.c2s.TrainRelocationPacket;
import org.jetbrains.annotations.Nullable;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class TrainRelocatorClient {

    static WeakReference<CarriageContraptionEntity> hoveredEntity = new WeakReference<>(null);
    static UUID relocatingTrain;
    static class_243 relocatingOrigin;
    static int relocatingEntityId;

    static class_2338 lastHoveredPos;
    static BezierTrackPointLocation lastHoveredBezierSegment;
    static Boolean lastHoveredResult;
    static List<class_243> toVisualise = new ArrayList<>();

    public static boolean onClicked(class_310 mc) {
        if (relocatingTrain == null)
            return false;

        class_746 player = mc.field_1724;
        if (player == null)
            return false;
        if (player.method_7325())
            return false;

        if (!player.method_19538().method_24802(relocatingOrigin, 24) || player.method_5715()) {
            relocatingTrain = null;
            player.method_7353(CreateLang.translateDirect("train.relocate.abort").method_27692(class_124.field_1061), true);
            return false;
        }

        if (player.method_5765())
            return false;
        if (mc.field_1687 == null)
            return false;
        Train relocating = getRelocating();
        if (relocating != null) {
            Boolean relocate = relocateClient(mc, relocating, false);
            if (relocate != null) {
                if (relocate) {
                    relocatingTrain = null;
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Boolean relocateClient(class_310 mc, Train relocating, boolean simulate) {
        class_239 hitResult = mc.field_1765;
        if (!(hitResult instanceof class_3965 blockhit))
            return null;

        class_2338 blockPos = blockhit.method_17777();
        BezierTrackPointLocation hoveredBezier = null;

        boolean upsideDown = relocating.carriages.getFirst().leadingBogey().isUpsideDown();
        class_243 offset = upsideDown ? new class_243(0, -0.5, 0) : class_243.field_1353;

        if (simulate && !toVisualise.isEmpty() && lastHoveredResult != null) {
            for (int i = 0; i < toVisualise.size() - 1; i++) {
                class_243 vec1 = toVisualise.get(i).method_1019(offset);
                class_243 vec2 = toVisualise.get(i + 1).method_1019(offset);
                Outliner.getInstance().showLine(Pair.of(relocating, i), vec1.method_1031(0, -.925f, 0), vec2.method_1031(0, -.925f, 0))
                    .colored(lastHoveredResult || i != toVisualise.size() - 2 ? 0x95CD41 : 0xEA5C2B).disableLineNormals()
                    .lineWidth(i % 2 == 1 ? 1 / 6f : 1 / 4f);
            }
        }

        BezierPointSelection bezierSelection = TrackBlockOutline.result;
        if (bezierSelection != null) {
            blockPos = bezierSelection.blockEntity().method_11016();
            hoveredBezier = bezierSelection.loc();
        }

        if (simulate) {
            if (lastHoveredPos != null && lastHoveredPos.equals(blockPos) && Objects.equals(lastHoveredBezierSegment, hoveredBezier))
                return lastHoveredResult;
            lastHoveredPos = blockPos;
            lastHoveredBezierSegment = hoveredBezier;
            toVisualise.clear();
        }

        class_2680 blockState = mc.field_1687.method_8320(blockPos);
        if (!(blockState.method_26204() instanceof ITrackBlock))
            return lastHoveredResult = null;

        class_243 lookAngle = mc.field_1724.method_5720();
        boolean direction = bezierSelection != null && lookAngle.method_1026(bezierSelection.direction()) < 0;
        boolean result = TrainRelocator.relocate(relocating, mc.field_1687, blockPos, hoveredBezier, direction, lookAngle, toVisualise);
        if (!simulate && result) {
            relocating.carriages.forEach(c -> c.forEachPresentEntity(e -> e.nonDamageTicks = 10));
            mc.field_1724.field_3944.method_52787(new TrainRelocationPacket(
                relocatingTrain,
                blockPos,
                lookAngle,
                relocatingEntityId,
                direction,
                hoveredBezier
            ));
        }

        return lastHoveredResult = result;
    }

    public static void clientTick(class_310 mc) {
        class_746 player = mc.field_1724;

        if (player == null)
            return;
        if (player.method_5765())
            return;
        class_638 world = mc.field_1687;
        if (world == null)
            return;

        if (relocatingTrain != null) {
            Train relocating = getRelocating();
            if (relocating == null) {
                relocatingTrain = null;
                return;
            }

            class_1297 entity = world.method_8469(relocatingEntityId);
            if (entity instanceof AbstractContraptionEntity ce && Math.abs(ce.method_30950(0).method_1020(ce.method_30950(1))
                .method_1027()) > 1 / 1024d) {
                player.method_7353(CreateLang.translateDirect("train.cannot_relocate_moving").method_27692(class_124.field_1061), true);
                relocatingTrain = null;
                return;
            }

            if (!player.method_6047().method_31574(AllItems.WRENCH)) {
                player.method_7353(CreateLang.translateDirect("train.relocate.abort").method_27692(class_124.field_1061), true);
                relocatingTrain = null;
                return;
            }

            if (!player.method_19538().method_24802(relocatingOrigin, 24)) {
                player.method_7353(CreateLang.translateDirect("train.relocate.too_far").method_27692(class_124.field_1061), true);
                return;
            }

            Boolean success = relocateClient(mc, relocating, true);
            if (success == null)
                player.method_7353(CreateLang.translateDirect("train.relocate", relocating.name), true);
            else if (success)
                player.method_7353(CreateLang.translateDirect("train.relocate.valid").method_27692(class_124.field_1060), true);
            else
                player.method_7353(CreateLang.translateDirect("train.relocate.invalid").method_27692(class_124.field_1061), true);
            return;
        }

        Couple<class_243> rayInputs = ContraptionHandlerClient.getRayInputs(mc, player);
        class_243 origin = rayInputs.getFirst();
        class_243 target = rayInputs.getSecond();

        CarriageContraptionEntity currentEntity = hoveredEntity.get();
        if (currentEntity != null) {
            if (ContraptionHandlerClient.rayTraceContraption(origin, target, currentEntity) != null)
                return;
            hoveredEntity = new WeakReference<>(null);
        }

        class_238 aabb = new class_238(origin, target);
        List<CarriageContraptionEntity> intersectingContraptions = world.method_18467(CarriageContraptionEntity.class, aabb);

        for (CarriageContraptionEntity contraptionEntity : intersectingContraptions) {
            if (ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity) == null)
                continue;
            hoveredEntity = new WeakReference<>(contraptionEntity);
        }
    }

    public static boolean carriageWrenched(class_243 vec3, CarriageContraptionEntity entity) {
        Train train = getTrainFromEntity(entity);
        if (train == null)
            return false;
        relocatingOrigin = vec3;
        relocatingTrain = train.id;
        relocatingEntityId = entity.method_5628();
        return true;
    }

    public static boolean addToTooltip(List<class_2561> tooltip) {
        Train train = getTrainFromEntity(hoveredEntity.get());
        if (train != null && train.derailed) {
            TooltipHelper.addHint(tooltip, "hint.derailed_train");
            return true;
        }
        return false;
    }

    private static Train getRelocating() {
        return relocatingTrain == null ? null : Create.RAILWAYS.trains.get(relocatingTrain);
    }

    private static Train getTrainFromEntity(CarriageContraptionEntity carriageContraptionEntity) {
        if (carriageContraptionEntity == null)
            return null;
        Carriage carriage = carriageContraptionEntity.getCarriage();
        if (carriage == null)
            return null;
        return carriage.train;
    }

}
